//=============================================================================
// HXCredits
//=============================================================================
class HXCredits extends HXMiscPickup;

var() int numCredits;
var localized String msgCreditsAdded;

// ----------------------------------------------------------------------
// state Pickup
// ----------------------------------------------------------------------

auto state Pickup
{
	function Frob(Actor Frobber, Inventory FrobWith)
	{
		local HXPlayerPawn Player;

		Super.Frob(Frobber, FrobWith);

		Player = HXPlayerPawn(Frobber);

		if (Player != None)
		{
			Player.Credits += numCredits;
			Player.ClientMessage(Sprintf(msgCreditsAdded, numCredits));
			Player.FrobTarget = None;
			Destroy();
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     numCredits=100
     msgCreditsAdded="%d credits added"
     ItemName="Credit Chit"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Credits'
     PickupViewMesh=LodMesh'DeusExItems.Credits'
     ThirdPersonMesh=LodMesh'DeusExItems.Credits'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconCredits'
     beltDescription="CREDITS"
     Mesh=LodMesh'DeusExItems.Credits'
     CollisionRadius=7.000000
     CollisionHeight=0.550000
     Mass=2.000000
     Buoyancy=3.000000
}
