//=============================================================================
// HXDNSResolver - joins a game by ip or hostname (broken)
//=============================================================================
class HXDNSResolver extends InternetLink;

// strings for resolve failed msg box
var localized string MsgResolveFailedTitle;
var localized string MsgResolveFailed;

// ----------------------------------------------------------------------
// Resolve()
// ----------------------------------------------------------------------

function Resolve(coerce string Domain)
{
	local IpAddr Addr; // dummy

	Log("Resolve(" $ Domain $ ") called");

	if (StringToIpAddr(Domain, Addr))
		// domain is already an ip addr
		GetPlayerPawn().ConsoleCommand("open " $ Domain);
	else
		// we need to resolve host name to work with open
		Super.Resolve(Domain);
}


// ----------------------------------------------------------------------
// Resolve()
// ----------------------------------------------------------------------

event Resolved(IpAddr Addr)
{
	local string IPString;

	Log("Resolved() called");
	Log("IpAddrToString(Addr) returns: " $ IpAddrToString(Addr));

	IPString = IpAddrToString(Addr);

	// if port is zero, strip it
	if (Addr.Port == 0)
		IPString = Left(IPString, InStr(IPString, ":"));	

	Log("IPString is: " $ IPString);

	GetPlayerPawn().ConsoleCommand("open " $ IPString);
}


// ----------------------------------------------------------------------
// Resolve()
// ----------------------------------------------------------------------

event ResolveFailed()
{
	Log("ResolvedFailed() called");
	HXRootWindow(HXPlayerPawn(GetPlayerPawn()).RootWindow).OpenMessageBox(MsgResolveFailedTitle, MsgResolveFailed, 0, None);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     MsgResolveFailedTitle="Resolve failed"
     MsgResolveFailed="Could not resolve host name"
}
