//=============================================================================
// HXEpisodeList.
//=============================================================================
class HXEpisodeList extends Info;

struct HXEpisode
{
	var string Title;
	var string Map;
};

var(Episodes) globalconfig HXEpisode	Episodes[32];
var(Episodes) globalconfig int				EpisodeNum;


function string GetNextMap()
{
	local string CurrentMap;
	local int i;

	CurrentMap = GetURLMap();

	if (CurrentMap != "")
	{
		if (Right(CurrentMap,3) ~= ".dx")
			CurrentMap = CurrentMap;
		else
			CurrentMap = CurrentMap$".dx";

		for (i = 0; i < 32; i++)
		{
			
			if (CurrentMap ~= Episodes[i].Map)
			{
				EpisodeNum = i;
				break;
			}
			
		}
	}

	EpisodeNum++;

	if (EpisodeNum > 31)
		EpisodeNum = 0;

	if (Episodes[EpisodeNum].Map == "")
		EpisodeNum = 0;

	SaveConfig();
	return Episodes[EpisodeNum].Map;
}

defaultproperties
{
     Episodes(0)=(Title="Training Facilities",Map="00_Training.dx")
     Episodes(1)=(Title="Liberty Island",Map="01_NYC_UNATCOIsland.dx")
     Episodes(2)=(Title="Battery Park",Map="02_NYC_BatteryPark.dx")
     EpisodeNum=1
}
