//=============================================================================
// HXGameInfo.
//=============================================================================

class HXGameInfo extends GameInfo
	native
	noexport;

var() string EntryPortal;

var NanoKeyInfo KeyList;
var HXMissionScript MissionScript;

var localized String AddedNanoKey;

native(2300) final function Engine					GetEngine();

native(2310) final function									EngineDeleteGame(int position);
native(2311) final function DeusExSaveInfo	EngineGetSaveInfo(Package saveInfoPackage);
native(2312) final function									EngineCopySaveGameFiles(string source, string dest);
native(2313) final function									EngineDeleteSaveGameFiles(optional string saveDirectory);
native(2314) final function DeusExSaveInfo	EngineLoadSaveInfo(optional int DirectoryIndex);
native(2315) final function									EnginePruneTravelActors();
native(2316) final function									EngineSaveCurrentLevel(optional int DirectoryIndex, optional bool bSavePlayer);
native(2317) final function int							EngineGetCurrentMissionNumber();
native(2318) final function int							EngineGetNextMissionNumber(string mapName);
native(2319) final function DeusExLevelInfo	EngineGetDeusExLevelInfo();
native(2320) final function									EngineSaveGame(int Position, optional string saveDesc);


// ----------------------------------------------------------------------
// IsRelevant()
// ----------------------------------------------------------------------

function bool IsRelevant(Actor Other)
{
	local HXMissionScriptReplaceEnum ReplaceEnum;

	local class<HXMissionScript> MyClass;

	// we need to disable 'Tick' and 'Timer' for 
	// every fucking DeusExMover so doors won't
	// getting closed instantly (i.e. can not be
	// opened if they were not unlocked)

	if (Other.isA('DeusExMover'))
	{
		Disable('Tick');
		Disable('Timer');
	}

	// we check for the DeusExLevelInfo to disable mission
	// script spawning by this class, and spawn our replacement
	// mission script as part of our gameinfo

	else if (Other.isA('DeusExLevelInfo'))
	{
		ReplaceEnum = new class'HXMissionScriptReplaceEnum';

		MyClass = class<HXMissionScript>(ReplaceEnum.GetReplacement(DeusExLevelInfo(Other).Script, false));

		if (MyClass != None)
		{
			MissionScript = Spawn(MyClass);
			Log("(II) Replaced MissionScript " $ DeusExLevelInfo(Other).Script $ " with " $ MissionScript.Class);
		}
		else
		{
			Log("(EE) No MissionScript Found");
		}

		CriticalDelete(ReplaceEnum);

		DeusExLevelInfo(Other).Script = None;
	}

	return Super.IsRelevant(Other);
}


// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------

event playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local HXPlayerPawn Player;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;
	local string RandomClassString;

	local int i;
	
	if (!ClassIsChildOf(SpawnClass, class'HXPlayerPawn'))
	{
		RandomClassString = "HXJCDenton";
	
		i = Rand(5);

		switch (i)
		{
			case 0:
				break;
			default:
				RandomClassString = RandomClassString $ i;
				break;
		}

		SpawnClass = class<playerpawn>(DynamicLoadObject(RandomClassString, class'HXPlayerPawn'));
	}

	Player = HXPlayerPawn(Super.Login(Portal, Options, Error, SpawnClass));

	if (player != None)
	{	
		//if (Level.Netmode == NM_ListenServer)
		EntryPortal = ConsoleCommand("get HXGameInfo EntryPortal");

		Log("EntryPortal is " $ EntryPortal);

		StartSpot = FindPlayerStart(Player, ,EntryPortal);

		if (StartSpot != None)
		{
			Log("StartSpot isA " $ StartSpot.Class $ " with Tag " $ StartSpot.Tag);
			Player.SetLocation(StartSpot.Location);
			Player.SetRotation(StartSpot.Rotation);
			Player.ViewRotation = StartSpot.Rotation;
			Player.ClientSetRotation(player.Rotation);
		}
		else
		{
			Log("Failed to find StartSpot");
		}

	}

	// test native functions
	//Log("(II) testing hxgameinfo native interfaces...");
	//Log("(==) GetEngine(): Engine Class is " $ GetEngine().Class);
	//Log("(==) EngineGetCurrentMissionNumber(): Mission Number is " $ EngineGetCurrentMissionNumber());
	//Log("(==) EngineGetNextMissionNumber(): Mission Number of Map '09_NYC_Graveyard' is " $ EngineGetNextMissionNumber("09_NYC_Graveyard"));
	//Log("(==) EngineGetDeusExLevelInfo(): DeusExLevelInfo Class is " $ EngineGetDeusExLevelInfo().Class);

	return player;
}


// ----------------------------------------------------------------------
// RestartPlayer()
// ----------------------------------------------------------------------

function bool RestartPlayer(pawn Player)	
{
	local NavigationPoint startSpot;
	local bool foundStart;

	if (bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode != NM_ListenServer)
		return true;

	startSpot = FindPlayerStart(Player, ,EntryPortal);

	if (startSpot == None)
	{
		log(" Player start not found!!!");
		return false;
	}	
	else
	{
		Player.SetLocation(StartSpot.Location);
		Player.SetRotation(StartSpot.Rotation);
		Player.ViewRotation = StartSpot.Rotation;
		Player.ClientSetLocation(StartSpot.Location, player.Rotation);

		Player.Acceleration = vect(0,0,0);
		Player.Velocity = vect(0,0,0);
		Player.Health = Player.Default.Health;
		Player.SetCollision(true, true, true);
		Player.bHidden = false;
		Player.DamageScaling = Player.Default.DamageScaling;
		Player.SoundDampening = Player.Default.SoundDampening;

		AddDefaultInventory(Player);

		return true;
	}
}


// ----------------------------------------------------------------------
// AddDefaultInventory()
// ----------------------------------------------------------------------

function AddDefaultInventory(pawn PlayerPawn)
{
	local Inventory Item;

	PlayerPawn.JumpZ = PlayerPawn.Default.JumpZ * PlayerJumpZScaling();
	 
	if(PlayerPawn.IsA('Spectator'))
		return;

	// add default equipment if not in training
	if (EngineGetCurrentMissionNumber() != 0)
	{
		// pistol
		Item = Spawn(class'HXWeaponPistol');
		Item.Frob(PlayerPawn, None);
		Item.bInObjectBelt = True;

		/*
		// prod
		Item = Spawn(class'WeaponProd');
		Item.Frob(PlayerPawn, None);
		Item.bInObjectBelt = True;
		*/

		// medkit
		Item = Spawn(class'HXMedKit');
		Item.Frob(PlayerPawn, None);
		Item.bInObjectBelt = True;
	}

	HXPlayerPawn(PlayerPawn).CreateKeyRing();
}


// ----------------------------------------------------------------------
// SendPlayer()
// ----------------------------------------------------------------------

function SendPlayer(PlayerPawn aPlayer, string URL)
{
	local GameDirectory SaveDir;
	local DeusExSaveInfo SaveInfo;
	local HXPlayerPawn Player;
	local int i;

	if (Level.Netmode == NM_Client)
		return;

	// handle non local players
	foreach AllActors(class'HXPlayerPawn', Player)
		if (NetConnection(Player.Player) != None)
			Player.ClientTravel(URL, TRAVEL_Relative, true);

	// save entry portal
	i = InStr(URL, "#");

	if (i >= 0)
		EntryPortal = Right(URL, Len(URL) - i - 1);
	else
		EntryPortal = "";

	ConsoleCommand("set HXGameInfo EntryPortal" @ EntryPortal);
	Log("Saved entry Portal" @ EntryPortal);

	EngineSaveCurrentLevel(23, false);

	// fix
	EngineGetDeusExLevelInfo().MissionNumber = -5;

	// do it
	if (Level.Netmode == NM_ListenServer)
		GetPlayerPawn().ClientTravel(URL $ "?load=23", TRAVEL_Relative, true);
	else
		Level.ServerTravel(URL $ "", true);

}



// ----------------------------------------------------------------------
// AddNanoKey()
// ----------------------------------------------------------------------

function AddNanoKey(name KeyID, string Desc)
{
	local NanoKeyInfo Key;

	if (HasNanoKey(KeyID))
		return;

	Key = new(Self) Class'NanoKeyInfo';

	Key.KeyID       = KeyID;
	Key.Description = Desc;
	Key.NextKey     = KeyList;
	KeyList					= Key;

	if (Role == ROLE_Authority)
		BroadcastMessage(Sprintf(AddedNanoKey, Desc));
}


// ----------------------------------------------------------------------
// HasNanoKey()
// ----------------------------------------------------------------------

function bool HasNanoKey(Name KeyToLookFor)
{
	local NanoKeyInfo Key;

	Key = KeyList;

	while (Key != None)
	{
		if (Key.KeyID == KeyToLookFor)
			return true;

		Key = Key.NextKey;
	}

	return false;
}


// ----------------------------------------------------------------------
// GetNanoKeyCount()
// ----------------------------------------------------------------------

function int GetKeyCount()
{
	local int keyCount;
	local NanoKeyInfo Key;

	Key = KeyList;

	while (Key != none)
	{
		keyCount++;
		Key = Key.NextKey;
	}

	return keyCount;
}


// ----------------------------------------------------------------------
// RemoveNanoKey()
// ----------------------------------------------------------------------

function RemoveKey(Name KeyToRemove)
{
	local NanoKeyInfo Key;
	local NanoKeyInfo LastKey;

	Key = KeyList;
			
	while (Key != None)
	{
		if (Key.KeyID == KeyToRemove)
		{
			if (LastKey != None)
				LastKey.NextKey = Key.NextKey;
			if (KeyList == Key)
				KeyList = Key.NextKey;

			CriticalDelete(Key);
			return;
		}

		LastKey = Key;
		Key = Key.NextKey;
	}

}


// ----------------------------------------------------------------------
// RemoveAllKeys()
// ----------------------------------------------------------------------

function RemoveAllKeys()
{
	local NanoKeyInfo Key;
	local NanoKeyInfo Tmp;
	
	for (Key = KeyList; Key != None; Key = Tmp)
	{
		Tmp = Key.NextKey;
		CriticalDelete(Key);
	}

	KeyList = None;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     AddedNanoKey="%s added to Nano Key Ring"
     MutatorClass=Class'HXCoop.HXMutator'
}
