//=============================================================================
// HXHUD
//=============================================================================
class HXHUD extends Window;

var Crosshair								Cross;
var HXFrobDisplayWindow			FrobDisplay;
var HXHUDInformationDisplay	InfoDisplay;
var HXHUDLogDisplay					LogDisplay;
var HXHUDHitDisplay					Hit;
var HXHUDCompassDisplay			Compass;
var HXHUDObjectBelt					Belt;
var HXHUDAmmoDisplay				Ammo;

var HXRootWindow Root;
var HXPlayerPawn Player;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	Root = HXRootWindow(GetRootWindow());
	Player = HXPlayerPawn(Root.ParentPawn);

	SetFont(Font'TechMedium');
	SetSensitivity(false);

	Ammo				= HXHUDAmmoDisplay(NewChild(Class'HXHUDAmmoDisplay'));
	Hit					= HXHUDHitDisplay(NewChild(Class'HXHUDHitDisplay'));
	InfoDisplay = HXHUDInformationDisplay(NewChild(Class'HXHUDInformationDisplay'));
	Cross				= Crosshair(NewChild(Class'Crosshair'));
	Compass			= HXHUDCompassDisplay(NewChild(Class'HXHUDCompassDisplay'));
	Belt				= HXHUDObjectBelt(NewChild(Class'HXHUDObjectBelt'));
	FrobDisplay = HXFrobDisplayWindow(NewChild(Class'HXFrobDisplayWindow'));
	LogDisplay	= HXHUDLogDisplay(NewChild(Class'HXHUDLogDisplay', False));

	FrobDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	LogDisplay.SetLogTimeout(Player.LogTimeout);
	InfoDisplay.Hide();
}


// ----------------------------------------------------------------------
// DescendantRemoved()
// ----------------------------------------------------------------------

event DescendantRemoved(Window descendant)
{
	if      (descendant == ammo)
		Ammo  = None;
	else if (descendant == Cross)
		Cross = None;
	else if (descendant == Hit)
		Hit = None;
	else if (descendant == Compass)
		Compass = None;
	else if (descendant == FrobDisplay)
		FrobDisplay = None;
	else if (descendant == Belt)
		Belt  = None;
	else if (descendant == LogDisplay)
		LogDisplay = None;
	else if (descendant == InfoDisplay)
		InfoDisplay = None;

}


// ----------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------

function ConfigurationChanged()
{
	local float qWidth, qHeight;
	local float compassWidth, compassHeight;
	local float beltWidth, beltHeight;
	local float ammoWidth, ammoHeight;
	local float hitWidth, hitHeight;
	local float infoX, infoY, infoTop, infoBottom;
	local float infoWidth, infoHeight, maxInfoWidth, maxInfoHeight;
	local float itemsWidth, itemsHeight;




	local float logTop;
/*
	

	local float damageWidth, damageHeight;
	local float conHeight;
	local float barkWidth, barkHeight;
	local float recWidth, recHeight, recPosY;
*/
	if (ammo != None)
	{
		if (ammo.IsVisible())
		{
			ammo.QueryPreferredSize(ammoWidth, ammoHeight);
			ammo.ConfigureChild(0, height-ammoHeight, ammoWidth, ammoHeight);
		}
		else
		{
			ammoWidth  = 0;
			ammoHeight = 0;
		}
	}

	if (Hit != None)
	{
		if (Hit.IsVisible())
		{
			Hit.QueryPreferredSize(hitWidth, hitHeight);
			Hit.ConfigureChild(0, 0, hitWidth, hitHeight);
		}
	}

	// Stick the Compass directly under the Hit display
	if (compass != None)
	{
		compass.QueryPreferredSize(compassWidth, compassHeight);
		compass.ConfigureChild(0, hitHeight + 4, compassWidth, compassHeight);

		if (hitWidth == 0)
			hitWidth = compassWidth;
	}

	if (Cross != None)
	{
		Cross.QueryPreferredSize(qWidth, qHeight);
		Cross.ConfigureChild((width-qWidth)*0.5+0.5, (height-qHeight)*0.5+0.5, qWidth, qHeight);
	}

	if (Belt != None)
	{
		Belt.QueryPreferredSize(beltWidth, beltHeight);
		Belt.ConfigureChild(width - beltWidth, height - beltHeight, beltWidth, beltHeight);

		infoBottom = height - beltHeight;
	}
	else
	{
		infoBottom = height;
	}


	// Display the Log in the upper-left corner, to the right of the hit display.
	if (LogDisplay != None)
	{
		qHeight = LogDisplay.QueryPreferredHeight(width - hitWidth - itemsWidth - 40);
		LogDisplay.ConfigureChild(hitWidth + 20, 10, width - hitWidth - itemsWidth - 40, qHeight);

		if (LogDisplay.IsVisible())
			logTop = max(infoTop, 10 + qHeight);
	}

	// Display the Info Window sandwiched between all the other windows.  :)
	if ((InfoDisplay != None) && (InfoDisplay.IsVisible(False)))
	{
		// Must redo these formulas
		maxInfoWidth  = Min(width - 170, 800);
		maxInfoHeight = (infoBottom - infoTop) - 20;

		InfoDisplay.QueryPreferredSize(infoWidth, infoHeight);

		if (infoWidth > maxInfoWidth)
		{
			infoHeight = InfoDisplay.QueryPreferredHeight(maxInfoWidth);
			infoWidth  = maxInfoWidth;
		}

		infoX = (width / 2) - (infoWidth / 2);
		infoY = infoTop + (((infoBottom - infoTop) / 2) - (infoHeight / 2)) + 10;

		InfoDisplay.ConfigureChild(infoX, infoY, infoWidth, infoHeight);
	}
}


// ----------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------

function bool ChildRequestedReconfiguration(window child)
{
	ConfigurationChanged();

	return true;
}

// ----------------------------------------------------------------------
// ChildRequestedVisibilityChange()
// ----------------------------------------------------------------------

function ChildRequestedVisibilityChange(window child, bool bNewVisibility)
{
	child.SetChildVisibility(bNewVisibility);

	ConfigurationChanged();
}

// ----------------------------------------------------------------------
// UpdateSettings()
// ----------------------------------------------------------------------

function UpdateSettings(HXPlayerPawn Player)
{
	Ammo.SetVisibility(player.bAmmoDisplayVisible);
	Hit.SetVisibility(Player.bHitDisplayVisible);
	Compass.SetVisibility(Player.bCompassVisible);
	Cross.SetCrosshair(Player.bCrosshairVisible);
	Belt.SetVisibility(player.bObjectBeltVisible);
}


// ----------------------------------------------------------------------
// ActivateObject()
// ----------------------------------------------------------------------

function bool ActivateObject(int pos)
{
	local Inventory Item;
	local bool retval;

	if (Belt == None || Player == None)
		return false;


	Item = Belt.GetObjectFromBelt(pos);
	Player.PutInHand(Item);
	
	return Item != None;
}


// ----------------------------------------------------------------------
// VisibilityChanged()
// ----------------------------------------------------------------------

event VisibilityChanged(bool bNewVisibility)
{
	Super.VisibilityChanged( bNewVisibility );

	if (LogDisplay != None && bNewVisibility)
		if (LogDisplay.MessagesWaiting())
			//if ( infoLink == None )
			LogDisplay.Show();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
