//=============================================================================
// HXHUDBaseWindow
//=============================================================================
class HXHUDBaseWindow extends Window
	abstract;

var HXPlayerPawn Player;

// Border and Background Translucency
var bool       bDrawBorder;
var EDrawStyle borderDrawStyle;
var EDrawStyle backgroundDrawStyle;

// Position/size of background
var int backgroundWidth;
var int backgroundHeight;
var int backgroundPosX;
var int backgroundPosY;

// Default Colors
var Color colBackground;
var Color colBorder;
var Color colHeaderText;
var Color colText;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	// Get a pointer to the player
	Player = HXPlayerPawn(GetRootWindow().parentPawn);

	StyleChanged();
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	// First draw the background then the border
	DrawBackground(gc);
	DrawBorder(gc);
}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
}

// ----------------------------------------------------------------------
// RefreshHUDDisplay()
// ----------------------------------------------------------------------

function RefreshHUDDisplay(float DeltaTime)
{
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;

	Theme = HXRootWindow(Player.RootWindow).ThemeManager.GetCurrentHUDColorTheme();

	coLBackground = Theme.GetColorFromName('HUDColor_Background');
	colBorder     = Theme.GetColorFromName('HUDColor_Borders');
	colText       = Theme.GetColorFromName('HUDColor_NormalText');
	colHeaderText = Theme.GetColorFromName('HUDColor_HeaderText');

	bDrawBorder   = Player.bHUDBordersVisible;

	if (Player.bHUDBordersTranslucent)
		borderDrawStyle = DSTY_Translucent;
	else
		borderDrawStyle = DSTY_Masked;

	if (Player.bHUDBackgroundTranslucent)
		backgroundDrawStyle = DSTY_Translucent;
	else
		backgroundDrawStyle = DSTY_Masked;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     bDrawBorder=True
     colBackground=(R=128,G=128,B=128)
     colBorder=(R=128,G=128,B=128)
     colText=(R=255,G=255,B=255)
}
