//=============================================================================
// HXHUDInformationDisplay
//=============================================================================
class HXHUDInformationDisplay extends HXHUDSharedBorderWindow;


var TileWindow winTile;
var Color colInfoText;
var Font fontInfo;

var Texture texBackgrounds[9];
var Texture texBorders[9];

var DeusExTextParser Parser;

var localized string msgTruePlayerName;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Create the tile window that will contain all the text windows
	winTile = TileWindow(NewChild(Class'TileWindow'));
	winTile.SetOrder( ORDER_Down );
	winTile.SetChildAlignments( HALIGN_Full, VALIGN_Top );
	winTile.SetMargins(20, 0);
	winTile.SetMinorSpacing(0);
	winTile.MakeWidthsEqual(True);
	winTile.MakeHeightsEqual(False);

	Parser = new(None) Class'DeusExTextParser';
}


// ----------------------------------------------------------------------
// ParentRequestedPreferredSize()
// ----------------------------------------------------------------------

event ParentRequestedPreferredSize(bool bWidthSpecified, out float preferredWidth,
                                   bool bHeightSpecified, out float preferredHeight)
{
	local float tileWidth, tileHeight;

	if (winTile.IsVisible())
	{
		if ((!bWidthSpecified) && (!bHeightSpecified))
		{
			winTile.QueryPreferredSize(preferredWidth, preferredHeight);

			preferredHeight += topMargin + bottomMargin;
	
			if (preferredHeight < minHeight)
				preferredHeight = minHeight;
		}
		else if (bWidthSpecified)
		{
			preferredHeight = winTile.QueryPreferredHeight(preferredWidth);
			preferredHeight += topMargin + bottomMargin;
	
			if (preferredHeight < minHeight)
				preferredHeight = minHeight;
		}
		else
		{
			preferredWidth = winTile.QueryPreferredWidth(preferredHeight + topMargin + bottomMargin);
		}
	}
}


// ----------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------

function ConfigurationChanged()
{
	winTile.ConfigureChild(0, topMargin, width, height);
}


// ----------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------

event bool ChildRequestedReconfiguration(window childWin)
{
	return False;
}


// ----------------------------------------------------------------------
// AddTextWindow()
//
// Adds a text window
// ----------------------------------------------------------------------

function TextWindow AddTextWindow()
{
	local TextWindow winText;

	// Create the Text window containing the message text
	winText = TextWindow(winTile.NewChild(Class'TextWindow'));
	winText.SetFont(fontInfo);
	winText.SetTextColor(colInfoText);
	winText.SetWordWrap(True);
	winText.SetTextAlignments(HALIGN_Left, VALIGN_Top);	
	winText.SetTextMargins(0, 0);

	AskParentForReconfigure();

	return winText;
}


// ----------------------------------------------------------------------
// ClearTextWindows()
//
// Removes all the text window
// ----------------------------------------------------------------------

function ClearTextWindows()
{
	winTile.DestroyAllChildren();
}


// ----------------------------------------------------------------------
// StopDisplay()
// ----------------------------------------------------------------------

function StopDisplay()
{
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());
	Root.Hud.Cross.Show();
	Root.Hud.FrobDisplay.Show();

	ClearTextWindows();

	Hide();
}



// ----------------------------------------------------------------------
// Display()
// ----------------------------------------------------------------------

function Display(name TextTag, string TextPackage)
{
	local byte Tag;
	local bool bFirstParagraph;
	local bool bSetText;
	local string VaultString;
	local string Text;
	local TextWindow WinText;
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());
	Root.Hud.Cross.Hide();
	Root.Hud.FrobDisplay.Hide();

	if (TextTag != '' && Parser.OpenText(TextTag, TextPackage))
	{
		Parser.SetPlayerName(msgTruePlayerName);
		Show();
		ClearTextWindows();
		
		bSetText = true;
		bFirstParagraph = true;
		VaultString = "";
		
		while (Parser.ProcessText())
		{
			// process tag
			Tag = Parser.GetTag();

			if (WinText == None)
			{
				WinText = AddTextWindow();
				bSetText = true;
			}

			switch(tag)
			{
				// add text
				case 0:
				case 9:
				case 10:
					Text = Parser.GetText();

					// Add the text
					if (bSetText)
						WinText.SetText(text);
					else
						WinText.AppendText(text);

					VaultString = VaultString $ text;
					bSetText = False;
					break;

				// align text
				case 12: winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);	break;
				case 13: winText.SetTextAlignments(HALIGN_Left, VALIGN_Center);		break;
				case 14: winText.SetTextAlignments(HALIGN_Right, VALIGN_Center);	break;

				// color change
				case 15:
				case 16:
				case 17:
					winText.SetTextColor(parser.GetColor());
					break;

				// new paragraph
				case 18:
					WinText = AddTextWindow();

					// Only add a return if this is not the *first*
					// paragraph.
					if (!bFirstParagraph)
						VaultString = VaultString $ WinText.CR();

					bFirstParagraph = false;
					bSetText = true;
					break;
			}
		}
		

		parser.CloseText();
	}
}



// ----------------------------------------------------------------------
// ProcessTag()
// ----------------------------------------------------------------------
/*
function ProcessTag(DeusExTextParser parser)
{
	local String text;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	// Make sure we have a text window to operate on.
	if (winText == None)
	{
		winText = infoWindow.AddTextWindow();
		bSetText = True;
	}

	switch(tag)
	{
		// If a winText window doesn't yet exist, create one.
		// Then add the text
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();

			// Add the text
			if (bSetText)
				winText.SetText(text);
			else
				winText.AppendText(text);

			vaultString = vaultString $ text;
			bSetText = False;
			break;

		// Create a new text window
		case 18:			// TT_NewParagraph:
			// Create a new text window
			winText = infoWindow.AddTextWindow();

			// Only add a return if this is not the *first*
			// paragraph.
			if (!bFirstParagraph)
				vaultString = vaultString $ winText.CR();

			bFirstParagraph = False;

			bSetText = True;
			break;

		case 13:				// TT_LeftJustify:
			winText.SetTextAlignments(HALIGN_Left, VALIGN_Center);
			break;

		case 14:			// TT_RightJustify:
			winText.SetTextAlignments(HALIGN_Right, VALIGN_Center);
			break;

		case 12:				// TT_CenterText:
			winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);
			break;

		case 26:			// TT_Font:
//			fontName = parser.GetName();
//			winText.SetFont(fontName);
			break;

		case 15:			// TT_DefaultColor:
		case 16:			// TT_TextColor:
		case 17:			// TT_RevertColor:
			winText.SetTextColor(parser.GetColor());
			break;
	}
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	local DeusExTextParser parser;
	local DeusExRootWindow rootWindow;
	local DeusExNote note;
	local DataVaultImage image;
	local bool bImageAdded;

	rootWindow = DeusExRootWindow(aReader.rootWindow);

	// First check to see if we have a name
	if (TextTag != '' )
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
								    
		// Attempt to find the text object
		if ((aReader != None) && (parser.OpenText(textTag,TextPackage)))
		{
			parser.SetPlayerName(aReader.TruePlayerName);

			infoWindow = rootWindow.hud.ShowInfoWindow();
			infoWindow.ClearTextWindows();

			vaultString = "";
			bFirstParagraph = True;

			while(parser.ProcessText())
				ProcessTag(parser);

			parser.CloseText();

			// Check to see if we need to save this string in the 
			// DataVault
			if (bAddToVault)
			{
				note = aReader.GetNote(textTag);

				if (note == None)
				{
					note = aReader.AddNote(vaultString,, True);
					note.SetTextTag(textTag);
				}

				vaultString = "";
			}
		}
		CriticalDelete(parser);
	}

	// do we have any image data to give the player?
	if ((imageClass != None) && (aReader != None))
	{
		image = Spawn(imageClass, aReader);
		if (image != None)  
		{
			image.GiveTo(aReader);
			image.SetBase(aReader);
			bImageAdded = aReader.AddImage(image);

			// Display a note to the effect that there's an image here, 
			// but only if nothing else was displayed
			if (infoWindow == None)
			{
				infoWindow = rootWindow.hud.ShowInfoWindow();
				winText = infoWindow.AddTextWindow();
				winText.SetText(Sprintf(ImageLabel, image.imageDescription));
			}

			// Log the fact that the user just got an image.
			if (bImageAdded)
			{
				aReader.ClientMessage(Sprintf(AddedToDatavaultLabel, image.imageDescription));
			}
		}
	}
}



*/

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colInfoText=(R=250,G=250,B=250)
     fontInfo=Font'DeusExUI.FontMenuSmall_DS'
     msgTruePlayerName="JC Denton"
}
