//=============================================================================
// HXLockpick
//=============================================================================
class HXLockpick expands HXSkilledTool;

var DeusExMover Target;

var int		NumPicks;
var float	TicksSinceLastPick;
var float	TicksPerPick;
var float	LastTickTime;

var localized string msgAlreadyUnlocked;
var localized string msgOtherPicking;
var localized string msgLockpickSuccess;

// ----------------------------------------------------------------------
// CanPick()
// ----------------------------------------------------------------------

function bool CanPick(DeusExMover M)
{
	if (M == None || !M.bPickable)
		return false;

	// abort if another player is already picking
	if (M.bPicking)
	{
		Pawn(Owner).ClientMessage(msgOtherPicking);
		return false;
	}

	// already unlocked
	if (!M.bLocked)
	{
		Pawn(Owner).ClientMessage(msgAlreadyUnlocked);
		return false;
	}

	return true;
}


// ----------------------------------------------------------------------
// Pick()
// ----------------------------------------------------------------------

function Pick(DeusExMover M)
{
	Target = M;

	GotoState('UseIt');
}


// ----------------------------------------------------------------------
// AbortPick()
// ----------------------------------------------------------------------

function StopPick()
{
	HXPlayerPawn(Owner).bPicking = false;
	GotoState('StopIt');
	bBeingUsed = false;
	Target.bPicking = false;
	SetTimer(0.0, false);
}


// ----------------------------------------------------------------------
// state UseIt
// ----------------------------------------------------------------------

state UseIt
{
	function Timer()
	{
		local DeusExMover M;

		TicksSinceLastPick += (Level.TimeSeconds - LastTickTime) * 10;
		LastTickTime = Level.TimeSeconds;

		while (TicksSinceLastPick > TicksPerPick)
		{
			NumPicks--;
			Target.LockStrength -= 0.01;
			TicksSinceLastPick -= TicksPerPick;      
			Target.LockStrength = FClamp(Target.LockStrength, 0.0, 1.0);
		}

		// pick all like-tagged movers at once (for double doors and such)
		if ((Target.Tag != '') && (Target.Tag != 'DeusExMover'))
			foreach AllActors(class'DeusExMover', M, Target.Tag)
				if (M != Target)
					M.LockStrength = Target.LockStrength;


		// did we unlock it?
		if (Target.LockStrength ~= 0.0)
		{
			Target.LockStrength = 0.0;
			Target.bLocked = False;
			Target.TimeSinceReset = 0.0;

			// unlock all like-tagged movers at once (for double doors and such)
			if ((Target.Tag != '') && (Target.Tag != 'DeusExMover'))
				foreach AllActors(class'DeusExMover', M, Target.Tag)
					if (M != Target)
						M.bLocked = False;

			Pawn(Owner).ClientMessage(msgLockpickSuccess);
			StopPick();
		}

		// are we done with this pick?
		else if (numPicks <= 0)
			StopPick();

	}


Begin:
	if ((Level.NetMode != NM_Standalone) && (Owner != None))
		SetLocation(Owner.Location);

	AIStartEvent('MegaFutz', EAITYPE_Visual);

	bBeingUsed = true;
	Target.bPicking = true;

	// switch num picks depending on skill level
	switch (HXPlayerPawn(Owner).GetSkillLevel(Skill_LockPicking))
	{
		case 0: NumPicks = 10; break;
		case 1: NumPicks = 25; break;
		case 2: NumPicks = 40; break;
		case 3: NumPicks = 75; break;
		default: Warn("(EE) Could not determine NumPicks for Player" $ Owner);
	}

	TicksPerPick = (Target.PickTime * 10.0) / NumPicks;
	LastTickTime = Level.TimeSeconds;
	TicksSinceLastPick = 0;

	SetTimer(0.1, true);
	
	AmbientSound = useSound;
	PlayAnim('UseBegin',, 0.1);
	FinishAnim();
	LoopAnim('UseLoop',, 0.1);
}



// ----------------------------------------------------------------------
// state StopIt
// ----------------------------------------------------------------------

state StopIt
{
	function PutDown()
	{
		
	}

Begin:
	AmbientSound = None;
	PlayAnim('UseEnd',, 0.1);
	FinishAnim();
	UseOnce();
	GotoState('Idle', 'DontPlaySelect');
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     msgAlreadyUnlocked="It's already unlocked"
     msgOtherPicking="Another Player is already picking the lock"
     msgLockpickSuccess="You picked the lock"
     UseSound=Sound'DeusExSounds.Generic.LockpickRattling'
     maxCopies=20
     bCanHaveMultipleCopies=True
     ItemName="Lockpick"
     PlayerViewOffset=(X=16.000000,Y=8.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LockpickPOV'
     PickupViewMesh=LodMesh'DeusExItems.Lockpick'
     ThirdPersonMesh=LodMesh'DeusExItems.Lockpick3rd'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconLockPick'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLockPick'
     largeIconWidth=45
     largeIconHeight=44
     Description="A disposable lockpick. The tension wrench is steel, but appropriate needles are formed from fast congealing polymers.|n|n<UNATCO OPS FILE NOTE AJ006-BLACK> Here's what they don't tell you: despite the product literature, you can use a standard lockpick to bypass all but the most high-class nanolocks. -- Alex Jacobson <END NOTE>"
     beltDescription="LOCKPICK"
     Mesh=LodMesh'DeusExItems.Lockpick'
     CollisionRadius=11.750000
     CollisionHeight=1.900000
     Mass=20.000000
     Buoyancy=10.000000
}
