//=============================================================================
// HXMedKit
//=============================================================================
class HXMedKit extends HXHealthPickup;

var bool bNoPrintMustBeUsed;
var localized string MustBeUsedOn;


// ----------------------------------------------------------------------
// state Activated
// ----------------------------------------------------------------------

state Activated
{
	function BeginState()
	{
		local HXPlayerPawn Player;
		
		Super(HXPickup).BeginState();

		Player = HXPlayerPawn(Owner);

		if (Player != None)
			Player.HealPlayer(CalculateSkillHealAmount(HealAmount));
		
		PlaySound(sound'MedicalHiss', SLOT_None,,, 256);
		UseOnce();
	}
Begin:
}


// ----------------------------------------------------------------------
// CalculateSkillHealAmount()
// ----------------------------------------------------------------------

function int CalculateSkillHealAmount(int BaseHealPoints)
{
/*
	local float mult;
	local int adjustedHealAmount;

	// check skill use
	if (SkillSystem != None)
	{
		mult = SkillSystem.GetSkillLevelValue(class'SkillMedicine');

		// apply the skill
		adjustedHealAmount = baseHealPoints * mult;
	}

	return adjustedHealAmount;
*/
	return BaseHealPoints;
}


// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local DeusExPlayer player;
	local String outText;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		winInfo.SetTitle(itemName);
		winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

		if (!bNoPrintMustBeUsed)
		{
			winInfo.AppendText(winInfo.CR() $ MustBeUsedOn $ winInfo.CR());
		}
		else
		{
			bNoPrintMustBeUsed = False;
		}

		// Print the number of copies
		outText = CountLabel @ String(NumCopies);

		winInfo.AppendText(winInfo.CR() $ outText);
	}

	return True;
}


// ----------------------------------------------------------------------
// NoPrintMustBeUsed()
// ----------------------------------------------------------------------

function NoPrintMustBeUsed()
{
	bNoPrintMustBeUsed = True;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     MustBeUsedOn="Use to heal critical body parts, or use on character screen to direct healing at a certain body part."
     healAmount=30
     maxCopies=15
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Medkit"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.MedKit'
     PickupViewMesh=LodMesh'DeusExItems.MedKit'
     ThirdPersonMesh=LodMesh'DeusExItems.MedKit3rd'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconMedKit'
     largeIcon=Texture'DeusExUI.Icons.LargeIconMedKit'
     largeIconWidth=39
     largeIconHeight=46
     Description="A first-aid kit.|n|n<UNATCO OPS FILE NOTE JR095-VIOLET> The nanomachines of an augmented agent will automatically metabolize the contents of a medkit to efficiently heal damaged areas. An agent with medical training could greatly expedite this process. -- Jaime Reyes <END NOTE>"
     beltDescription="MEDKIT"
     Mesh=LodMesh'DeusExItems.MedKit'
     CollisionRadius=7.500000
     CollisionHeight=1.000000
     Mass=10.000000
     Buoyancy=8.000000
}
