//=============================================================================
// HXMenuChoice_Class
//=============================================================================
class HXMenuChoice_Class extends HXMenuUIChoiceEnum
	config;


// JC Denton portraits
#exec texture IMPORT FILE="Textures\Menu\HXMenuPlayerSetupJCDenton_1.pcx"	NAME="HXMenuPlayerSetupJCDenton_1"	GROUP="UserInterface"	MIPS=Off
#exec texture IMPORT FILE="Textures\Menu\HXMenuPlayerSetupJCDenton_2.pcx"	NAME="HXMenuPlayerSetupJCDenton_2"	GROUP="UserInterface"	MIPS=Off
#exec texture IMPORT FILE="Textures\Menu\HXMenuPlayerSetupJCDenton_3.pcx"	NAME="HXMenuPlayerSetupJCDenton_3"	GROUP="UserInterface"	MIPS=Off
#exec texture IMPORT FILE="Textures\Menu\HXMenuPlayerSetupJCDenton_4.pcx"	NAME="HXMenuPlayerSetupJCDenton_4"	GROUP="UserInterface"	MIPS=Off
#exec texture IMPORT FILE="Textures\Menu\HXMenuPlayerSetupJCDenton_5.pcx"	NAME="HXMenuPlayerSetupJCDenton_5"	GROUP="UserInterface"	MIPS=Off


var globalconfig string  ClassClasses[24]; //Actual classes of classes (sigh)
var localized String     ClassNames[24]; //Human readable class names.

//Portrait variables
var ButtonWindow btnPortrait;
var globalconfig Texture texPortraits[24];
var int PortraitIndex;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateClassChoices();
	CreatePortraitButton();

	Super.InitWindow();

	SetInitialClass();

	SetActionButtonWidth(153);

	btnAction.SetHelpText(HelpText);
	btnInfo.SetPos(0,195);
}

// ----------------------------------------------------------------------
// PopulateClassChoices()
// ----------------------------------------------------------------------

function PopulateClassChoices()
{
	local int typeIndex;

   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      enumText[typeIndex]=ClassNames[typeIndex];
   }
}

// ----------------------------------------------------------------------
// SetInitialClass()
// ----------------------------------------------------------------------

function SetInitialClass()
{
   local string TypeString;
   local int typeIndex;

   
   TypeString = player.GetDefaultURL("Class");
  
   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// SetValue()
// ----------------------------------------------------------------------

function SetValue(int newValue)
{
   Super.SetValue(newValue);
   UpdatePortrait();
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.UpdateURL("Class", GetModuleName(currentValue), true);
   player.SaveConfig();
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local string TypeString;
   local int typeIndex;
   
   TypeString = player.GetDefaultURL("Class");

   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
   UpdatePortrait();
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.UpdateURL("Class", GetModuleName(defaultValue), true);
   player.SaveConfig();
   LoadSetting();
}

// ----------------------------------------------------------------------
// GetModuleName()
// For command line parsing
// ----------------------------------------------------------------------

function string GetModuleName(int ClassIndex)
{
   return (ClassClasses[ClassIndex]);
}

// ----------------------------------------------------------------------
// CreatePortraitButton()
// ----------------------------------------------------------------------

function CreatePortraitButton()
{
	btnPortrait = ButtonWindow(NewChild(Class'ButtonWindow'));

	btnPortrait.SetSize(116, 163);
	btnPortrait.SetPos(19, 27);

	btnPortrait.SetBackgroundStyle(DSTY_Masked);
}

// ----------------------------------------------------------------------
// UpdatePortrait()
// ----------------------------------------------------------------------

function UpdatePortrait()
{
   btnPortrait.SetBackground(texPortraits[CurrentValue]);
}


// ----------------------------------------------------------------------
// CreateInfoButton()
// ----------------------------------------------------------------------

function CreateInfoButton()
{
	btnInfo = HXMenuUIInfoButtonWindow(NewChild(Class'HXMenuUIInfoButtonWindow'));

	btnInfo.SetSelectability(False);
	btnInfo.SetSize(defaultInfoWidth, 19);
	btnInfo.SetPos(defaultInfoPosX, 0);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     ClassClasses(0)="HXCoop.HXJCDenton"
     ClassClasses(1)="HXCoop.HXJCDenton2"
     ClassClasses(2)="HXCoop.HXJCDenton3"
     ClassClasses(3)="HXCoop.HXJCDenton4"
     ClassClasses(4)="HXCoop.HXJCDenton5"
     ClassClasses(5)="HXCoop.HXMPNSF"
     ClassClasses(6)="HXCoop.HXMPUnatco"
     ClassClasses(7)="HXCoop.HXMPMJ12"
     ClassNames(0)="JC Denton"
     ClassNames(1)="JC Denton (2)"
     ClassNames(2)="JC Denton (3)"
     ClassNames(3)="JC Denton (4)"
     ClassNames(4)="JC Denton (5)"
     ClassNames(5)="NSF Terrorist"
     ClassNames(6)="UNATCO Trooper"
     ClassNames(7)="MJ12 Agent"
     texPortraits(0)=Texture'HXCoop.UserInterface.HXMenuPlayerSetupJCDenton_1'
     texPortraits(1)=Texture'HXCoop.UserInterface.HXMenuPlayerSetupJCDenton_2'
     texPortraits(2)=Texture'HXCoop.UserInterface.HXMenuPlayerSetupJCDenton_3'
     texPortraits(3)=Texture'HXCoop.UserInterface.HXMenuPlayerSetupJCDenton_4'
     texPortraits(4)=Texture'HXCoop.UserInterface.HXMenuPlayerSetupJCDenton_5'
     texPortraits(5)=Texture'DeusExUI.UserInterface.menuplayersetupnsf'
     texPortraits(6)=Texture'DeusExUI.UserInterface.menuplayersetupunatco'
     texPortraits(7)=Texture'DeusExUI.UserInterface.menuplayersetupmj12'
     defaultInfoWidth=153
     defaultInfoPosX=170
     HelpText="Model for your character."
     actionText="Model"
}
