//=============================================================================
// HXMenuChoice_HUDColor
//=============================================================================
class HXMenuChoice_HUDColor extends HXMenuChoice_ThemeColor;

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	// Populate the enums!
	PopulateThemes(1);

	currentTheme = HXRootWindow(GetRootWindow()).ThemeManager.GetCurrentHUDColorTheme();
	SetValueFromString(currentTheme.GetThemeName());
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	Player.HUDThemeName = enumText[GetValue()];
}

// ----------------------------------------------------------------------
// CancelSetting()
// ----------------------------------------------------------------------

function CancelSetting()
{
	HXRootWindow(GetRootWindow()).ThemeManager.SetCurrentMenuColorTheme(currentTheme);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// ResetToDefault()
// ----------------------------------------------------------------------

function ResetToDefault()
{
	local ColorTheme theme;

	Player.HUDThemeName = defaultTheme;
	theme = HXRootWindow(GetRootWindow()).ThemeManager.SetHUDThemeByName(defaultTheme);
	theme.ResetThemeToDefault();

	SetValueFromString(player.HUDThemeName);

	ChangeStyle();
}

// ----------------------------------------------------------------------
// CycleNextValue()
// ----------------------------------------------------------------------

function CycleNextValue()
{
	Super.CycleNextValue();
	HXRootWindow(GetRootWindow()).ThemeManager.SetHUDThemeByName(enumText[GetValue()]);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// CyclePreviousValue()
// ----------------------------------------------------------------------

function CyclePreviousValue()
{
	Super.CyclePreviousValue();
	HXRootWindow(GetRootWindow()).ThemeManager.SetHUDThemeByName(enumText[GetValue()]);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     defaultTheme="Grey"
     defaultInfoWidth=97
     HelpText="Color scheme used in all the in-game screens."
     actionText="|&HUD Color Scheme"
}
