//=============================================================================
// HXMenuChoice_MenuColor
//=============================================================================
class HXMenuChoice_MenuColor extends HXMenuChoice_ThemeColor;

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	// Populate the enums!
	PopulateThemes(0);

	currentTheme = HXRootWindow(GetRootWindow()).ThemeManager.GetCurrentMenuColorTheme();
	SetValueFromString(currentTheme.GetThemeName());
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	player.MenuThemeName = enumText[GetValue()];
}

// ----------------------------------------------------------------------
// CancelSetting()
// ----------------------------------------------------------------------

function CancelSetting()
{
	HXRootWindow(GetRootWindow()).ThemeManager.SetCurrentMenuColorTheme(currentTheme);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// ResetToDefault()
// ----------------------------------------------------------------------

function ResetToDefault()
{
	local ColorTheme theme;

	player.MenuThemeName = defaultTheme;
	theme = HXRootWindow(GetRootWindow()).ThemeManager.SetMenuThemeByName(defaultTheme);
	theme.ResetThemeToDefault();

	SetValueFromString(player.MenuThemeName);

	ChangeStyle();
}

// ----------------------------------------------------------------------
// CycleNextValue()
// ----------------------------------------------------------------------

function CycleNextValue()
{
	Super.CycleNextValue();
	HXRootWindow(GetRootWindow()).ThemeManager.SetMenuThemeByName(enumText[GetValue()]);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// CyclePreviousValue()
// ----------------------------------------------------------------------

function CyclePreviousValue()
{
	Super.CyclePreviousValue();
	HXRootWindow(GetRootWindow()).ThemeManager.SetMenuThemeByName(enumText[GetValue()]);
	ChangeStyle();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     defaultTheme="Grey"
     defaultInfoWidth=97
     HelpText="Color scheme used in all menus."
     actionText="|&Menu Color Scheme"
}
