//=============================================================================
// HXMenuChoice_RenderDevice
//=============================================================================
class HXMenuChoice_RenderDevice extends HXMenuUIChoiceAction;

var localized String PromptTitle;
var localized String GamePromptMessage;
var localized String RestartPromptMessage;

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated(Window buttonPressed)
{
	local HXRootWindow Root;

	Root = HXRootWindow(GetRootWindow());

	if (Player.Level.NetMode != NM_StandAlone)
		Root.OpenMessageBox(PromptTitle, GamePromptMessage, 0, Self);
	else
		Root.OpenMessageBox(PromptTitle, RestartPromptMessage, 0, Self);

	return True;
}

// ----------------------------------------------------------------------
// BoxOptionSelected()
// ----------------------------------------------------------------------

event bool BoxOptionSelected(Window button, int buttonNumber)
{
	// kill msg box
	HXRootWindow(GetRootWindow()).CloseTopMenu();

	// Restart
	if (buttonNumber == 0) 
	{
		SaveMenuSettings();
		Player.ConsoleCommand("RELAUNCH -changevideo INI=HX.ini USERINI=HXUser.ini");
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     PromptTitle="Restart Deus Ex?"
     GamePromptMessage="In order to choose a render device, Deus Ex must be restarted.  The current game you are playing will be lost if you have not already saved it.  Do you still wish to restart?"
     RestartPromptMessage="In order to choose a render device, Deus Ex must be restarted.  Do you wish to proceed?"
     Action=MA_Custom
     HelpText="Select the device to use for 3D rendering.  Deus Ex must EXIT to allow you to select a 3D hardware device."
     actionText="Rendering |&Device..."
}
