//=============================================================================
// HXMenuChoice_ThemeColor
//=============================================================================
class HXMenuChoice_ThemeColor extends HXMenuUIChoiceEnum;

var ColorTheme currentTheme;
var String     defaultTheme;

// ----------------------------------------------------------------------
// PopulateThemes()
// ----------------------------------------------------------------------

function PopulateThemes(int themeType)
{
	local HXRootWindow Root;
	local ColorTheme Theme;
	local int ThemeIndex;

	Root = HXRootWindow(GetRootWindow());
	
	Theme = Root.ThemeManager.GetFirstTheme(themeType);
	
	while (Theme != None)
	{
		enumText[ThemeIndex++] = Theme.GetThemeName();
		Theme = Root.ThemeManager.GetNextTheme();
	}
}

// ----------------------------------------------------------------------
// SetValueFromString()
// ----------------------------------------------------------------------

function SetValueFromString(String stringValue)
{
	local int enumIndex;

	for(enumIndex=0; enumIndex<arrayCount(enumText); enumIndex++)
	{
		if (enumText[enumIndex] == stringValue)
		{
			SetValue(enumIndex);
			break;
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
