//=============================================================================
// HXMenuChoice_WorldTextureDetail
//=============================================================================
class HXMenuChoice_WorldTextureDetail extends HXMenuUIChoiceEnum;

var String englishEnumText[3];

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local String detailString;
	local int enumIndex;
	local int detailChoice;

	detailString = player.ConsoleCommand("get " $ configSetting);
	detailChoice = 0;

	for (enumIndex=0; enumIndex<arrayCount(enumText); enumIndex++)
	{
		if (englishEnumText[enumIndex] == detailString)
		{
			detailChoice = enumIndex;
			break;
		}	
	}

	SetValue(detailChoice);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	player.ConsoleCommand("set " $ configSetting $ " " $ englishEnumText[GetValue()]);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     englishEnumText(0)="Low"
     englishEnumText(1)="Medium"
     englishEnumText(2)="High"
     enumText(0)="Low"
     enumText(1)="Medium"
     enumText(2)="High"
     defaultInfoWidth=98
     HelpText="Change the amount of texture detail in the world"
     actionText="|&World Texture Detail"
     configSetting="ini:Engine.Engine.ViewportManager TextureDetail"
}
