//=============================================================================
// HXMenuMain
//=============================================================================
class HXMenuMain expands HXMenuUIMenuWindow;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	if (player.Level.Netmode != NM_Standalone)
	{
		winButtons[0].SetSensitivity(False);
		winButtons[1].SetSensitivity(False);
		winButtons[4].SetSensitivity(True);
		winButtons[5].SetSensitivity(True);
	}
	else
	{
		winButtons[0].SetSensitivity(True);
		winButtons[1].SetSensitivity(True);
		winButtons[4].SetSensitivity(False);
		winButtons[5].SetSensitivity(False);
	}
}


// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton(string key)
{
	switch(key)
	{
		case "DISCONNECT":
			Player.DisconnectPlayer();
			break;
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     ButtonNames(0)="Net Game"
     ButtonNames(1)="Lan Game"
     ButtonNames(2)="Settings"
     ButtonNames(3)="Player Setup"
     ButtonNames(4)="Continue"
     ButtonNames(5)="Disconnect"
     ButtonNames(6)="Exit"
     buttonXPos=7
     buttonWidth=282
     buttonDefaults(0)=(Y=13,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuScreenJoinNet')
     buttonDefaults(1)=(Y=49,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuScreenJoinLan')
     buttonDefaults(2)=(Y=121,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuSettings')
     buttonDefaults(3)=(Y=157,Action=MA_MenuScreen,Invoke=Class'HXCoop.HXMenuScreenPlayerSetup')
     buttonDefaults(4)=(Y=193,Action=MA_Previous)
     buttonDefaults(5)=(Y=85,Action=MA_Custom,Key="DISCONNECT")
     buttonDefaults(6)=(Y=266,Action=MA_Quit)
     Title="HX Coop"
     ClientWidth=294
     ClientHeight=308
     clientTextures(0)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.MenuOptionsBackground_4'
     textureCols=2
}
