//=============================================================================
// HXMenuUIChoiceEdit
//=============================================================================
class HXMenuUIChoiceEdit extends HXMenuUIChoice;

var HXMenuUIEditWindow Editor;
var() string FilterString;

var int    DefaultEditWidth;
var int    DefaultEditPosX;

// depricated
var string CurrentValue;
var string DefaultValue;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetActionButtonWidth(179);
	CreateEditor();
}


// ----------------------------------------------------------------------
// CreateEditor()
// ----------------------------------------------------------------------

function CreateEditor()
{
	Editor = HXMenuUIEditWindow(NewChild(Class'HXMenuUIEditWindow'));

	Editor.MoveInsertionPoint(MOVEINSERT_End);
	Editor.SetFilter(FilterString);
	Editor.SetSize(DefaultEditWidth, 19);
	Editor.SetPos(DefaultEditPosX, 0);
}

// ----------------------------------------------------------------------
// UpdateInfoButton()
// ----------------------------------------------------------------------

function UpdateInfoButton()
{
//	btnInfo.SetButtonText(enumText[currentValue]);
}

// ----------------------------------------------------------------------
// SetValue()
// ----------------------------------------------------------------------

function SetValue(string newValue)
{
	CurrentValue = newValue;
	UpdateInfoButton();
}

// ----------------------------------------------------------------------
// GetValue()
// ----------------------------------------------------------------------

function string GetValue()
{
	return CurrentValue;
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	if (ConfigSetting != "")
		SetValue(Player.ConsoleCommand("get " $ ConfigSetting));
	else
		ResetToDefault();
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	if (configSetting != "")
		Player.ConsoleCommand("set " $ configSetting $ " " $ GetValue());
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function ResetToDefault()
{
	if (configSetting != "")
	{
		Player.ConsoleCommand("set " $ ConfigSetting $ " " $ DefaultValue);
		LoadSetting();
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     filterString="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890[]() "
     DefaultEditWidth=77
     DefaultEditPosX=203
     choiceControlPosX=203
}
