//=============================================================================
// HXMenuUIEditWindow
//=============================================================================
class HXMenuUIEditWindow extends EditWindow;

var Color colText;
var Color colHighlight;
var Color colCursor;
var Color colBlack;

var Font  fontText;
var Int   maxHeight;

// Optional filter string
var String FilterString;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	SetFont(fontText);
	SetHeight(maxHeight);
	SetInsertionPointType(INSTYPE_Insert);
	EnableSingleLineEditing(True);

	StyleChanged();
}

// ----------------------------------------------------------------------
// FilterChar()
//
// Prevent the user from typing illegal characters
// ----------------------------------------------------------------------

function bool FilterChar(out string chStr)
{
	local int filterIndex;
	local bool bResult;

	if (filterString == "")
	{
		bResult = True;
	}
	else
	{
		bResult = False;

		for(filterIndex=0; filterIndex < Len(filterString); filterIndex++)
		{
			if ( Mid(filterString, filterIndex, 1) == chStr )
			{
				bResult = True;
				break;
			}
		}
	}

	return bResult;
}

// ----------------------------------------------------------------------
// SetFilter()
// ----------------------------------------------------------------------

function SetFilter(String newFilterString)
{
	filterString = newFilterString;
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;

	Theme = HXRootWindow(GetRootWindow()).ThemeManager.GetCurrentMenuColorTheme();

	// Title colors
	colText          = Theme.GetColorFromName('MenuColor_ListText');
	colHighlight     = Theme.GetColorFromName('MenuColor_ListHighlight');
	colCursor        = Theme.GetColorFromName('MenuColor_Cursor');

	SetTextColor(colText);
	SetTileColor(colHighlight);
	SetSelectedAreaTexture(Texture'Solid', coltext);
	SetSelectedAreaTextColor(colBlack);
	SetEditCursor(Texture'DeusExEditCursor', Texture'DeusExEditCursor_Shadow', colCursor);
	SetInsertionPointTexture(Texture'Solid', colCursor);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     fontText=Font'DeusExUI.FontMenuSmall'
     maxHeight=11
}
