//=============================================================================
// HXMenuUIHelpWindow
//=============================================================================
class HXMenuUIHelpWindow extends TextWindow;

// Defaults
var int xMargin;
var int yMargin;

var Color colText;
var Font  fontText;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetFont(fontText);
	SetTextMargins(xMargin, yMargin);
	SetTextAlignments(HALIGN_Left, VALIGN_Center);

	StyleChanged();
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;

	Theme = HXRootWindow(GetRootWindow()).ThemeManager.GetCurrentMenuColorTheme();

	// Title colors
	colText = Theme.GetColorFromName('MenuColor_HelpText');

	SetTextColor(colText);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     xMargin=10
     colText=(R=255,G=255,B=255)
     fontText=Font'DeusExUI.FontMenuSmall'
}
