//=============================================================================
// HXMenuUILabelWindow
//=============================================================================
class HXMenuUILabelWindow extends TextWindow;

var Color colLabel;
var Font  fontLabel;
var int fontBaseLine;
var int fontAcceleratorLineHeight;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetFont(fontLabel);
	SetTextMargins(0, 0);
	SetTextAlignments(HALIGN_Left, VALIGN_Top);
	SetBaselineData(fontBaseLine, fontAcceleratorLineHeight);

	StyleChanged();
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;

	Theme = HXRootWindow(GetRootWindow()).ThemeManager.GetCurrentMenuColorTheme();

	// Title colors
	colLabel = theme.GetColorFromName('MenuColor_ListText');

	SetTextColor(colLabel);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colLabel=(R=255,G=255,B=255)
     fontLabel=Font'DeusExUI.FontMenuTitle'
     fontBaseLine=1
     fontAcceleratorLineHeight=1
}
