//=============================================================================
// HXMutator
//=============================================================================
class HXMutator expands Mutator;

var bool bEnumsCreated;

var HXSkilledToolReplaceEnum		SkilledToolReplaceEnum;
var HXChargedPickupReplaceEnum	ChargedPickupReplaceEnum;
var HXWeaponModReplaceEnum			WeaponModReplaceEnum;
var HXDeusExPickupReplaceEnum		DeusExPickupReplaceEnum;



// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

event PreBeginPlay()
{
	Super.PreBeginPlay();

	SkilledToolReplaceEnum		= new class'HXSkilledToolReplaceEnum';
	ChargedPickupReplaceEnum	= new class'HXChargedPickupReplaceEnum';
	WeaponModReplaceEnum			= new class'HXWeaponModReplaceEnum';
	DeusExPickupReplaceEnum		= new class'HXDeusExPickupReplaceEnum';
}


// ----------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------

event Destroyed()
{
	Super.Destroyed();

	CriticalDelete(SkilledToolReplaceEnum);
	CriticalDelete(ChargedPickupReplaceEnum);
	CriticalDelete(WeaponModReplaceEnum);
	CriticalDelete(DeusExPickupReplaceEnum);
}


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	// inventory
	if (Other.isA('Inventory'))
	{
		// no need to replace inventory with an owner 
		// (e.g. ScriptedPawns) since the default inventory
		// classes are modified
		if (Other.Owner != none)
			return true;

		// weapons
		if (Other.isA('DeusExWeapon'))
		{
			
		}

		// generic pickups
		else if (Other.isA('DeusExPickup'))
		{
			// charged pickup
			if (Other.isA('ChargedPickup'))
				return ReplaceDeusExPickup(DeusExPickup(Other), class<HXPickup>(ChargedPickupReplaceEnum.GetReplacement(Other.Class, false)));

			// skilled tool
			else if (Other.isA('SkilledTool'))
				return ReplaceDeusExPickup(DeusExPickup(Other), class<HXPickup>(SkilledToolReplaceEnum.GetReplacement(Other.Class, false)));

			// weapon mod
			else if (Other.isA('WeaponMod'))
				return ReplaceDeusExPickup(DeusExPickup(Other), class<HXPickup>(WeaponModReplaceEnum.GetReplacement(Other.Class, false)));

			// other pickups
			else
				return ReplaceDeusExPickup(DeusExPickup(Other), class<HXPickup>(DeusExPickupReplaceEnum.GetReplacement(Other.Class, false)));
		
		}

		// ammo
		else if (Other.isA('DeusExAmmo'))
		{

		}
	
	}

	// scripted pawns
	else if (Other.isA('ScriptedPawn'))
	{
		if (Other.isA('HXScriptedPawn'))
			return true;

		// animals
		if (Other.isA('Animal'))
		{
		
		}

		// human civilians
		else if (Other.isA('HumanCivilian'))
		{
		
		}

		// human militaries
		else if (Other.isA('HumanMilitary'))
		{
		
		}

		// human thugs
		else if (Other.isA('HumanThug'))
		{
		
		}

		// robot
		else if (Other.isA('Robot'))
		{
		
		}
	}

	return true;
}


// ----------------------------------------------------------------------
// ReplaceWithClass()
// ----------------------------------------------------------------------
/*
function bool ReplaceWithClass(Actor Other, class<Actor>)
{
	local Actor A;
	local class<Actor> aClass;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
			Inventory(A).bHeldItem = true;
			Inventory(A).Respawntime = 0.0;
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
		return true;
	}
	return false;
}
*/

// ----------------------------------------------------------------------
// ReplaceDeusExPickup()
// ----------------------------------------------------------------------

function bool ReplaceDeusExPickup(DeusExPickup Other, class<HXPickup> PClass)
{
	local HXPickup P;

	//if (PClass == none)
		//return true;

	P = Spawn(PClass, None, Other.Tag, Other.Location, Other.Rotation);

	if (P == none)
	{
		Log("(EE) Failed to Replace " $ Other.Class $ " with " $ PClass $ " - Keeping");
		return true;
	}
	
	P.Event = Other.Event;

	return false;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
