//=============================================================================
// HXNanoKeyRing
//=============================================================================
class HXNanoKeyRing extends HXSkilledTool;

var localized string NoKeys;
var localized string KeysAvailableLabel;

var localized string	msgKeyLocked;			// message when key locked door
var localized string	msgKeyUnlocked;			// message when key unlocked door
var localized string	msgLockpickSuccess;		// message when lock is picked
var localized string	msgOneWayFail;			// message when one-way door can't be opened
var localized string	msgLocked;				// message when the door is locked
var localized string	msgPicking;				// message when the door is being picked
var localized string	msgAlreadyUnlocked;		// message when the door is already unlocked
var localized string	msgNoNanoKey;			// message when the player doesn't have the right nanokey

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local NanoKeyInfo keyInfo;
	local int keyCount;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(KeysAvailableLabel);
	winInfo.AddLine();

	/*
	if (GetPlayer() != None)
	{
		keyInfo = GetPlayer().KeyList;

		if (keyInfo != None)
		{
			while(keyInfo != None)
			{
				winInfo.SetText("  " $ keyInfo.Description);
				keyInfo = keyInfo.NextKey;
				keyCount++;
			}
		}
	}
	*/

	if (keyCount > 0)
	{
		winInfo.AddLine();
		winInfo.SetText(Description);
	}
	else
	{
		winInfo.Clear();
		winInfo.SetTitle(itemName);
		winInfo.SetText(NoKeys);
	}

	return True;
}


// ----------------------------------------------------------------------
// Use()
// ----------------------------------------------------------------------

function Use(Pawn User)
{
	local HXPlayerPawn Player;
	local DeusExMover Door, OtherDoor;

	Super.Use(User);

	if (Owner == none || HXPlayerPawn(Owner) == none)
		return;

	Player = HXPlayerPawn(Owner);

	// not a door
	if (!Player.FrobTarget.isA('DeusExMover'))
		return;

	PlayUseAnim();
	Door = DeusExMover(Player.FrobTarget);

	if (HXGameInfo(Level.Game).HasNanoKey(Door.KeyIDNeeded))
	{
		if ((Door.Tag != '') && (Door.Tag != 'DeusExMover'))
			foreach AllActors(class'DeusExMover', OtherDoor, Door.Tag)
				OtherDoor.bLocked = !OtherDoor.bLocked;

		if (Door.bLocked)
			Player.ClientMessage(msgKeyLocked);
		else
			Player.ClientMessage(msgKeyUnlocked);
	}
	else if (Door.bLocked)
		Player.ClientMessage(msgNoNanoKey);
	else
		Player.ClientMessage(msgAlreadyUnlocked);
	
}


// ----------------------------------------------------------------------
// state UseIt
// ----------------------------------------------------------------------

state UseIt
{
	function PutDown()
	{
		
	}

Begin:
	PlaySound(useSound, SLOT_None);
	PlayAnim('UseBegin',, 0.1);
	FinishAnim();
	LoopAnim('UseLoop',, 0.1);
	GotoState('StopIt');
}


// ----------------------------------------------------------------------
// state StopIt
// ----------------------------------------------------------------------

state StopIt
{
	function PutDown()
	{
		
	}

Begin:
	PlayAnim('UseEnd',, 0.1);
	GotoState('Idle', 'DontPlaySelect');
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     NoKeys="No Nano Keys Available!"
     KeysAvailableLabel="Nano Keys Available:"
     msgKeyLocked="Your NanoKey Ring locked it"
     msgKeyUnlocked="Your NanoKey Ring unlocked it"
     msgLockpickSuccess="You picked the lock"
     msgOneWayFail="It won't open from this side"
     msgLocked="It's locked"
     msgPicking="Picking the lock..."
     msgAlreadyUnlocked="It's already unlocked"
     msgNoNanoKey="Your NanoKey Ring doesn't have the right code"
     UseSound=Sound'DeusExSounds.Generic.KeysRattling'
     bDisplayableInv=False
     ItemName="Nanokey Ring"
     ItemArticle="the"
     PlayerViewOffset=(X=16.000000,Y=15.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.NanoKeyRingPOV'
     PickupViewMesh=LodMesh'DeusExItems.NanoKeyRing'
     ThirdPersonMesh=LodMesh'DeusExItems.NanoKeyRing'
     Icon=Texture'DeusExUI.Icons.BeltIconNanoKeyRing'
     largeIcon=Texture'DeusExUI.Icons.LargeIconNanoKeyRing'
     largeIconWidth=47
     largeIconHeight=44
     Description="A nanokey ring can read and store the two-dimensional molecular patterns from different nanokeys, and then recreate those patterns on demand."
     beltDescription="KEY RING"
     bHidden=True
     Mesh=LodMesh'DeusExItems.NanoKeyRing'
     CollisionRadius=5.510000
     CollisionHeight=4.690000
     Mass=10.000000
     Buoyancy=5.000000
}
