//=============================================================================
// HXPlayerPawn.
//=============================================================================
class HXPlayerPawn extends PlayerPawnExt
	native
	noexport
	abstract;

enum EPlayerSkills
{
	Skill_WeaponHeavy,
	Skill_WeaponPistol,
	Skill_WeaponRifle,
	Skill_WeaponLowTech,
	Skill_WeaponDemolition,
	Skill_Environment,
	Skill_LockPicking,
	Skill_Tech,
	Skill_Medicine,
	Skill_Computer,
	Skill_Swimming
};

var byte SkillLevels[11];

var globalconfig String MenuThemeName;
var globalconfig String HUDThemeName;

// Translucency settings for various UI Elements
var globalconfig Bool bHUDBordersVisible;
var globalconfig Bool bHUDBordersTranslucent;
var globalconfig Bool bHUDBackgroundTranslucent;
var globalconfig Bool bMenusTranslucent;

var globalconfig float LogTimeout;

// Configuration Variables
var globalconfig bool bObjectNames;					// Object names on/off
var globalconfig bool bSubtitles;					// True if Conversation Subtitles are on
var globalconfig bool bAlwaysRun;					// True to default to running
var globalconfig bool bToggleCrouch;				// True to let key toggle crouch
var globalconfig bool bHelpMessages;				// Multiplayer help messages
var globalconfig bool bAutoReload;

var globalconfig bool bHUDShowAllAugs;
var globalconfig int  UIBackground;					// 0 = Render 3D, 1 = Snapshot, 2 = Black

// UI stuff
var globalconfig bool bCrosshairVisible;
var globalconfig bool bHitDisplayVisible;
var globalconfig bool bCompassVisible;
var globalconfig bool bObjectBeltVisible;
var globalconfig bool bAmmoDisplayVisible;

// length of time player can stay underwater
// modified by SkillSwimming, AugAqualung, and Rebreather
var float swimDuration;
var float swimTimer;
var float swimBubbleTimer;

// frob vars
var() float MaxFrobDistance;
var Actor FrobTarget;
var float FrobTime;

// Inventory System Vars
//var travel byte				invSlots[30];		// 5x6 grid of inventory slots
//var int								maxInvRows;			// Maximum number of inventory rows
//var int								maxInvCols;			// Maximum number of inventory columns

var travel Inventory		inHand;				// The current object in hand
var travel Inventory		inHandPending;		// The pending item waiting to be put in hand
var travel Inventory		ClientinHandPending; // Client temporary inhand pending, for mousewheel use.
var travel bool					bInHandTransition;	// The inHand is being swapped out

var travel HXNanoKeyRing KeyRing;		// Inventory Item

var travel int		Credits;					// Credits (money) the player has
var travel float	Energy;						// Energy the player has
var travel float	EnergyMax;				// travel? WTF
var travel float	EnergyDrain;			// amount of energy left to drain
var travel float	EnergyDrainTotal;	// total amount of energy to drain

// used while crouching
var travel bool bForceDuck;
var travel bool bCrouchOn;				// used by toggle crouch
var travel bool bWasCrouchOn;			// used by toggle crouch
var travel byte lastbDuck;				// used by toggle crouch

// toggle walk
var bool bToggleWalk;

// leaning vars
var bool bCanLean;
var float curLeanDist;
var float prevLeanDist;

// fuckin' strings
var localized String InventoryFull;
var localized String TooMuchAmmo;
var localized String TooHeavyToLift;
var localized String CannotLift;
var localized String NoRoomToLift;
var localized String CanCarryOnlyOne;
var localized String CannotDropHere;
var localized String HandsFull;
var localized String NoteAdded;
var localized String GoalAdded;
var localized String PrimaryGoalCompleted;
var localized String SecondaryGoalCompleted;
var localized String EnergyDepleted;
var localized String HealedPointsLabel;
var localized String HealedPointLabel;
var localized String SkillPointsAward;
var localized String QuickSaveGameTitle;
var localized String WeaponUnCloak;
var localized String TakenOverString;
var localized String HeadString;
var localized String TorsoString;
var localized String LegsString;
var localized String WithTheString;
var localized String WithString;
var localized String PoisonString;
var localized String BurnString;
var localized String NoneString;

var bool bPicking;
var bool bMultitooling;
var bool bReading;

native(2400) final function DeusExLevelInfo	GetDeusExLevelInfo();
native(2401) final function int							GetMissionNumber();

function bool PlayerIsListenClient() { return ((GetPlayerPawn() == Self) && (Level.NetMode == NM_ListenServer)); }
function bool PlayerIsRemoteClient() { return ((Level.NetMode == NM_Client) && (Role == ROLE_AutonomousProxy)); }
function bool PlayerIsClient() { return (PlayerIsListenClient() || PlayerIsRemoteClient()); }



//
// network replication
//
replication
{
	// server to client
	reliable if (Role == ROLE_Authority)
		ClientShowInfoDev, ClientAbortReading, PutInHand, bAutoReload;

	// client to server
	//reliable if (Role < ROLE_Authority)
		//;
}



event Possess()
{
	Super.Possess();

	// this checks makes some headache...
	if (PlayerIsClient())
		HXRootWindow(RootWindow).UpdateHudVisibility();

}


// ----------------------------------------------------------------------
// ToggleWalk()
// ----------------------------------------------------------------------

exec function ToggleWalk()
{
	if (RestrictInput())
		return;

	bToggleWalk = !bToggleWalk;
}

// ----------------------------------------------------------------------
// ReloadWeapon()
// ----------------------------------------------------------------------

exec function ReloadWeapon()
{
	if (!RestrictInput() && Weapon.isA('HXWeaponProjectile'))
		HXWeaponProjectile(Weapon).Reload();
}

// ----------------------------------------------------------------------
// ToggleScope()
// ----------------------------------------------------------------------

exec function ToggleScope()
{
	if (!RestrictInput() && Weapon.isA('HXWeaponProjectile')) 
		HXWeaponProjectile(Weapon).ToggleScope();
}

// ----------------------------------------------------------------------
// ToggleLaser()
// ----------------------------------------------------------------------

exec function ToggleLaser()
{
	if (!RestrictInput() && Weapon.isA('HXWeaponProjectile')) 
		HXWeaponProjectile(Weapon).ToggleLaser();
}


// ----------------------------------------------------------------------
// ActivateBelt()
// ----------------------------------------------------------------------

exec function ActivateBelt(int objectNum)
{
	local HXRootWindow Root;

	Root = HXRootWindow(rootWindow);

	if (RestrictInput() || Root == None || CarriedDecoration != None)
		return;

	Root.Hud.ActivateObject(objectNum);
}


// ----------------------------------------------------------------------
// NextBeltItem()
// ----------------------------------------------------------------------

exec function NextBeltItem()
{	
	local HXRootWindow Root;
	local int Slot, StartSlot;

	Root = HXRootWindow(rootWindow);

	if (RestrictInput() || Root == None || CarriedDecoration != None)
		return;

	Slot = 0;

	if (ClientInHandPending != None)
		Slot = ClientInHandPending.beltPos;
	else if (inHandPending != None)
		Slot = inHandPending.beltPos;
	else if (inHand != None)
		Slot = inHand.beltPos;

	StartSlot = Slot;
	do
	{
		if (++Slot >= 10)
			Slot = 0;
	}
	until (Root.Hud.ActivateObject(slot) || (startSlot == slot));

	ClientInHandPending = Root.Hud.Belt.GetObjectFromBelt(slot);
}


// ----------------------------------------------------------------------
// PrevBeltItem()
// ----------------------------------------------------------------------

exec function PrevBeltItem()
{
	local HXRootWindow Root;
	local int Slot, StartSlot;

	Root = HXRootWindow(rootWindow);

	if (RestrictInput() || Root == None || CarriedDecoration != None)
		return;

	Slot = 0;

	if (ClientInHandPending != None)
		Slot = ClientInHandPending.beltPos;
	else if (inHandPending != None)
		Slot = inHandPending.beltPos;
	else if (inHand != None)
		Slot = inHand.beltPos;

	StartSlot = Slot;
	do
	{
		if (--slot <= -1)
			slot = 9;
	}
	until (Root.Hud.ActivateObject(slot) || (startSlot == slot));

	ClientInHandPending = Root.Hud.Belt.GetObjectFromBelt(slot);
}


// ----------------------------------------------------------------------
// DisconnectPlayer()
// ----------------------------------------------------------------------

exec function DisconnectPlayer()
{

	// TODO
	//if (RootWindow.isA('HXRootWindow'))
		//HXRootWindow(RootWindow).ClearWindowStack();

	if (PlayerIsRemoteClient())
		ConsoleCommand("disconnect");

	if (PlayerIsListenClient())
		ConsoleCommand("start dx.dx");
}



// ----------------------------------------------------------------------
// RenderOverlays()
// render our in-hand object
// ----------------------------------------------------------------------

simulated event RenderOverlays( canvas Canvas )
{
	if (Weapon != None)
		Weapon.RenderOverlays(Canvas);

	//if (!IsInState('Interpolating') && !IsInState('Paralyzed'))
	if ((inHand != None) && (!inHand.IsA('HXWeapon')))
		inHand.RenderOverlays(Canvas);
}


// ----------------------------------------------------------------------
// ClientShowInfoDev()
// ----------------------------------------------------------------------

simulated function ClientShowInfoDev(name TextTag, string TextPackage)
{
	HXRootWindow(RootWindow).Hud.InfoDisplay.Display(TextTag, TextPackage);
}


// ----------------------------------------------------------------------
// ClientAbortReading()
// ----------------------------------------------------------------------

simulated function ClientAbortReading()
{
	HXRootWindow(RootWindow).Hud.InfoDisplay.StopDisplay();
}


// ----------------------------------------------------------------------
// GetSkillLevel()
// ----------------------------------------------------------------------

function int GetSkillLevel(EPlayerSkills Skill)
{
	return SkillLevels[Skill];
}


// ----------------------------------------------------------------------
// CreateKeyRing()
// ----------------------------------------------------------------------

function CreateKeyRing()
{
	if (KeyRing == None)
	{
		KeyRing = Spawn(class'HXNanoKeyRing', Self);
		KeyRing.InitialState='Idle2';
		KeyRing.GiveTo(Self);
		KeyRing.SetBase(Self);
	}
}


// ----------------------------------------------------------------------
// Summon()
// ----------------------------------------------------------------------

exec function Summon(string ClassName)
{
	local class<actor> NewClass;

//	if(!bCheatsEnabled)
//		return;
//	if(!bAdmin && (Level.Netmode != NM_Standalone))
//		return;

//	Log( "Fabricate " $ ClassName );

	NewClass = class<actor>( DynamicLoadObject( ClassName, class'Class' ) );

	if (NewClass != None)
		// DEUS_EX STM
		//Spawn( NewClass,,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
		Spawn( NewClass,,,Location + (CollisionRadius+NewClass.Default.CollisionRadius+30) * Vector(Rotation) + vect(0,0,1) * 15 );
}


// ----------------------------------------------------------------------
// ShowMainMenu()
// ----------------------------------------------------------------------

exec function ShowMainMenu()
{
	local HXRootWindow Root;

	Root = HXRootWindow(rootWindow);

	if (Root != None)
		Root.OpenMenu(Class'HXMenuMain');
}


// ----------------------------------------------------------------------
// UpdateFrobTarget()
// ----------------------------------------------------------------------

function UpdateFrobTarget()
{
	local Actor target, smallestTarget;
	local Vector HitLoc, HitNormal, StartTrace, EndTrace;
	local float minSize;
	local bool bFirstTarget;
	local Actor OldFrobTarget;

	if (IsInState('Dying'))
		return;

	OldFrobTarget = FrobTarget;

	// figure out how far ahead we should trace
	StartTrace = Location;
	EndTrace = Location + (Vector(ViewRotation) * MaxFrobDistance);

	// adjust for the eye height
	StartTrace.Z += BaseEyeHeight;
	EndTrace.Z += BaseEyeHeight;

	smallestTarget = None;
	minSize = 99999;
	bFirstTarget = True;

	foreach TraceActors(class'Actor', target, HitLoc, HitNormal, EndTrace, StartTrace)
	{
		if (IsFrobbable(target) && (target != CarriedDecoration))
		{
			if (target.IsA('ScriptedPawn'))
			{
				smallestTarget = target;
				break;
			}
			else if (target.IsA('Mover') && bFirstTarget)
			{
				smallestTarget = target;
				break;
			}
			else if (target.CollisionRadius < minSize)
			{
				minSize = target.CollisionRadius;
				smallestTarget = target;
				bFirstTarget = False;
			}
		}
	}

	FrobTarget = smallestTarget;

	if (FrobTarget != OldFrobTarget)
	{
		Log("Changed FrobTarget to " $ FrobTarget.Class);

		if (InHand != none)
		{
			// abort lockpicking
			if (bPicking && InHand.isA('HXLockpick'))
			{
				HXLockpick(InHand).StopPick();
			}

			// abort bypassing
			if (bMultitooling && InHand.isA('HXMultitool'))
			{
				HXMultitool(InHand).AbortBypass();
				bMultitooling = false;
			}
		}

		if (bReading)
		{
			ClientAbortReading();
			bReading = false;
		}
	}
}



// ----------------------------------------------------------------------
// IsFrobbable()
// ----------------------------------------------------------------------

function bool IsFrobbable(actor A)
{
	if (A == none || bBehindView || A.bDeleteMe || A.bHidden)
		return false;
	else if (A.IsA('DeusExMover') && DeusExMover(A).bHighlight)
		return true;
	else if (A.IsA('DeusExDecoration') && DeusExDecoration(A).bHighlight)
		return true;
	else if (A.IsA('HXDecoration') && HXDecoration(A).bHighlight)
		return true;
	else if (A.IsA('Inventory') || A.IsA('DeusExCarcass'))
		return true;
	else if (A.IsA('ScriptedPawn') && ScriptedPawn(A).bHighlight)
		return true;
	else if (A.IsA('HXPlayerPawn'))
		return true;
	else if (A.IsA('DeusExProjectile'))
		if (A.IsA('ThrownProjectile') && ThrownProjectile(A).bHighlight)
			return true;
		else if (DeusExProjectile(A).bStuck)
			return true;
	else
		return false;
}


// ----------------------------------------------------------------------
// GetDisplayName()
// ----------------------------------------------------------------------

function String GetDisplayName(Actor actor, optional Bool bUseFamiliar)
{
	if ((actor == None) || (player == None) || (rootWindow == None))
		return "";
	else if (actor.IsA('DeusExDecoration'))
		return DeusExDecoration(actor).itemName;
	else if ((actor.FamiliarName != "") && ((actor.LastConEndTime > 0) || (bUseFamiliar)))
		return actor.FamiliarName;
	else if (actor.UnfamiliarName != "")
		return actor.UnfamiliarName;
	else return actor.BindName;
}


// ----------------------------------------------------------------------
// DeleteInventory()
// ----------------------------------------------------------------------

function bool DeleteInventory(Inventory Item)
{
	local bool retval;
	local HXRootWindow root;
	local PersonaScreenInventory winInv;

	// If the item was inHand, clear the inHand
	if (InHand == Item)
	{
		SetInHand(None);
		SetInHandPending(None);
	}

	// Make sure the item is removed from the inventory grid
	//RemoveItemFromSlot(item);

	Item.bInObjectBelt = false;
	Item.beltPos = -1;

	
	Root = HXRootWindow(rootWindow);

	// clear inventory in ui
	if (Root != None)
		if (Root.Hud != None)
			if (Root.Hud.Belt != None)
				Root.Hud.Belt.RemoveObjectFromBelt(Item);

	return Super.DeleteInventory(item);
}

// ----------------------------------------------------------------------
// HealPlayer()
// ----------------------------------------------------------------------

function int HealPlayer(int baseHealPoints)
{
	local float mult;
	local int adjustedHealAmount, aha2, tempaha;
	local int origHealAmount;
	local float dividedHealAmount;

	origHealAmount = baseHealPoints;

	if (baseHealPoints > 0)
	{
		HealPart(HealthHead, baseHealPoints);
		HealPart(HealthTorso, baseHealPoints);
		HealPart(HealthLegRight, baseHealPoints);
		HealPart(HealthLegLeft, baseHealPoints);
		HealPart(HealthArmRight, baseHealPoints);
		HealPart(HealthArmLeft, baseHealPoints);

		GenerateTotalHealth();

		if ((origHealAmount - baseHealPoints) == 1)
			ClientMessage(Sprintf(HealedPointLabel, 1));
		else
			ClientMessage(Sprintf(HealedPointsLabel, (origHealAmount - baseHealPoints)));

	}

	return adjustedHealAmount;
}


// ----------------------------------------------------------------------
// GenerateTotalHealth()
// ----------------------------------------------------------------------

function GenerateTotalHealth()
{
	local float ave, avecrit;

	ave = (HealthLegLeft + HealthLegRight + HealthArmLeft + HealthArmRight) / 4.0;

	if ((HealthHead <= 0) || (HealthTorso <= 0))
		avecrit = 0;
	else
		avecrit = (HealthHead + HealthTorso) / 2.0;

	if (avecrit == 0)
		Health = 0;
	else
		Health = (ave + avecrit) / 2.0;
}


// ----------------------------------------------------------------------
// HealPart()
// ----------------------------------------------------------------------

function HealPart(out int points, out int amt)
{
	local int spill;

	points += amt;
	spill = points - 100;
	if (spill > 0)
		points = 100;
	else
		spill = 0;

	amt = spill;
}


// ----------------------------------------------------------------------
// ParseLeftClick()
// ----------------------------------------------------------------------

exec function ParseLeftClick()
{
	local HXLockpick Pick;
	local DeusExMover Door;

	// we have nothing in our hand or are switching aktive inventory
	if (InHand == None || bInHandTransition)
		return;

	// health pickup's etc.
	if (InHand.bActivatable)
	{
		InHand.Activate();
		return;
	}

	if (FrobTarget == None)
		return;

	if (FrobTarget.IsA('DeusExMover'))
	{
		// lockpicks
		if (InHand.isA('HXLockpick') && HXLockPick(InHand).CanPick(DeusExMover(FrobTarget)))
		{
			Pick = HXLockpick(InHand);
			Pick.Pick(DeusExMover(FrobTarget));
			bPicking = true;
		}

		// nano keyring
		if (InHand.isA('HXNanoKeyRing'))
			HXNanoKeyRing(InHand).Use(Self);

	}

}


// ----------------------------------------------------------------------
// ParseRightClick()
// ----------------------------------------------------------------------

exec function ParseRightClick()
{
	local InformationDevices InfoDev;
	local DeusExMover Door;
	local Vector SavedFrobLocation;
	local bool bShowPickupAnim;

	if (FrobTarget != None)
	{
		bShowPickupAnim = false;
		SavedFrobLocation = FrobTarget.Location;

		// alert NPCs that I'm messing with stuff
		if (FrobTarget.bOwned)
			AISendEvent('Futz', EAITYPE_Visual);

		// handle decoration
		if (FrobTarget.IsA('Decoration') && Decoration(FrobTarget).bPushable)
		{
			GrabDecoration();
			bShowPickupAnim = CarriedDecoration == FrobTarget;
		}

		// handle nano keys
		else if (FrobTarget.IsA('NanoKey'))
		{
			bShowPickupAnim = true;
			HXGameInfo(Level.Game).AddNanoKey(NanoKey(FrobTarget).KeyID, NanoKey(FrobTarget).Description);
			FrobTarget.Destroy();
		}

		// handle movers
		else if (FrobTarget.IsA('DeusExMover'))
		{
			Door = DeusExMover(FrobTarget);

			if (Door.bLocked)
			{
				if (Door.KeyNum != 0 || Door.PrevKeyNum != 0)
					Door.Frob(Self, None);
				else
					ClientMessage(KeyRing.msgLocked);
			}
			else
				Door.Frob(Self, None);

		}

		// handle information devices
		else if (FrobTarget.IsA('InformationDevices'))
		{
			InfoDev = InformationDevices(FrobTarget);

			ClientShowInfoDev(InfoDev.TextTag, InfoDev.TextPackage);
			bReading = true;
		}

		// handle rest
		else
		{
			FrobTarget.Frob(Self, None);

			// if the object destroyed itself, get out
			if (FrobTarget == None)
				bShowPickupAnim = true;
				
			// if the inventory item aborted it's own pickup, get out
			else if (FrobTarget.IsA('Inventory') && (FrobTarget.Owner != Self))
				bShowPickupAnim = false;
		}
		
		if (bShowPickupAnim)
			PlayPickupAnim(SavedFrobLocation);
	}
	// frob target is empty, so drop decoration if carried
	else if (CarriedDecoration != None)
	{
		DropDecoration();
	}

	Log("Frob() called " $ FrobTarget.Class);
}


// check to see if the player can lift a certain decoration taking
// into account his muscle augs
function bool CanBeLifted(Decoration deco)
{
	local int augLevel, augMult;
	local float maxLift;

	maxLift = 50;

/*
	if (AugmentationSystem != None)
	{
		augLevel = AugmentationSystem.GetClassLevel(class'AugMuscle');
		augMult = 1;
		if (augLevel >= 0)
			augMult = augLevel+2;
		maxLift *= augMult;
	}
*/

	if (!deco.bPushable || (deco.Mass > maxLift) || (deco.StandingCount > 0))
	{
		if (deco.bPushable)
			ClientMessage(TooHeavyToLift);
		else
			ClientMessage(CannotLift);

		return False;
	}

	return True;
}

// ----------------------------------------------------------------------
// GrabDecoration()
//
// This overrides GrabDecoration() in Pawn.uc
// lets the strength augmentation affect how much the player can lift
// ----------------------------------------------------------------------

function GrabDecoration()
{
	// can't grab decorations while leaning
	if (IsLeaning())
		return;

	// can't grab decorations while holding something else
	if (inHand != None)
	{
		ClientMessage(HandsFull);
		return;
	}

	if (carriedDecoration == None)
		if ((FrobTarget != None) && FrobTarget.IsA('Decoration') && (Weapon == None))
			if (CanBeLifted(Decoration(FrobTarget)))
			{
				CarriedDecoration = Decoration(FrobTarget);
				PutCarriedDecorationInHand();
			}
}

// ----------------------------------------------------------------------
// PutCarriedDecorationInHand()
// ----------------------------------------------------------------------

function PutCarriedDecorationInHand()
{
	local vector lookDir, upDir;

	if (CarriedDecoration != None)
	{
		lookDir = Vector(Rotation);
		lookDir.Z = 0;
		upDir = vect(0,0,0);
		upDir.Z = CollisionHeight / 2;		// put it up near eye level
		CarriedDecoration.SetPhysics(PHYS_Falling);

		if ( CarriedDecoration.SetLocation(Location + upDir + (0.5 * CollisionRadius + CarriedDecoration.CollisionRadius) * lookDir) )
		{
			CarriedDecoration.SetPhysics(PHYS_None);
			CarriedDecoration.SetBase(self);
			CarriedDecoration.SetCollision(False, False, False);
			CarriedDecoration.bCollideWorld = False;

			// make it translucent
			CarriedDecoration.Style = STY_Translucent;
			CarriedDecoration.ScaleGlow = 1.0;
			CarriedDecoration.bUnlit = True;

			FrobTarget = None;
		}
		else
		{
			ClientMessage(NoRoomToLift);
			CarriedDecoration = None;
		}
	}
}

// ----------------------------------------------------------------------
// DropDecoration()
//
// This overrides DropDecoration() in Pawn.uc
// lets the player throw a decoration instead of just dropping it
// ----------------------------------------------------------------------

function DropDecoration()
{
	local Vector X, Y, Z, dropVect, origLoc, HitLocation, HitNormal, extent;
	local float velscale, size, mult;
	local bool bSuccess;
	local Actor hitActor;

	bSuccess = False;

	if (CarriedDecoration != None)
	{
		origLoc = CarriedDecoration.Location;
		GetAxes(Rotation, X, Y, Z);

		// if we are highlighting something, try to place the object on the target
		if ((FrobTarget != None) && !FrobTarget.IsA('Pawn'))
		{
			CarriedDecoration.Velocity = vect(0,0,0);

			// try to drop the object about one foot above the target
			size = FrobTarget.CollisionRadius - CarriedDecoration.CollisionRadius * 2;
			dropVect.X = size/2 - FRand() * size;
			dropVect.Y = size/2 - FRand() * size;
			dropVect.Z = FrobTarget.CollisionHeight + CarriedDecoration.CollisionHeight + 16;
			dropVect += FrobTarget.Location;
		}
		else
		{
			mult = 1.0;
			/*
			// throw velocity is based on augmentation
			if (AugmentationSystem != None)
			{
				mult = AugmentationSystem.GetAugLevelValue(class'AugMuscle');
				if (mult == -1.0)
					mult = 1.0;
			}
			*/

			if (IsLeaning())
				CarriedDecoration.Velocity = vect(0,0,0);
			else
				CarriedDecoration.Velocity = Vector(ViewRotation) * mult * 500 + vect(0,0,220) + 40 * VRand();

			// scale it based on the mass
			velscale = FClamp(CarriedDecoration.Mass / 20.0, 1.0, 40.0);

			CarriedDecoration.Velocity /= velscale;
			dropVect = Location + (CarriedDecoration.CollisionRadius + CollisionRadius + 4) * X;
			dropVect.Z += BaseEyeHeight;
		}

		// is anything blocking the drop point? (like thin doors)
		if (FastTrace(dropVect))
		{
			CarriedDecoration.SetCollision(True, True, True);
			CarriedDecoration.bCollideWorld = True;

			// check to see if there's space there
			extent.X = CarriedDecoration.CollisionRadius;
			extent.Y = CarriedDecoration.CollisionRadius;
			extent.Z = 1;
			hitActor = Trace(HitLocation, HitNormal, dropVect, CarriedDecoration.Location, True, extent);

			if ((hitActor == None) && CarriedDecoration.SetLocation(dropVect))
				bSuccess = True;
			else
			{
				CarriedDecoration.SetCollision(False, False, False);
				CarriedDecoration.bCollideWorld = False;
			}
		}

		// if we can drop it here, then drop it
		if (bSuccess)
		{
			CarriedDecoration.bWasCarried = True;
			CarriedDecoration.SetBase(None);
			CarriedDecoration.SetPhysics(PHYS_Falling);
			CarriedDecoration.Instigator = Self;

			// turn off translucency
			CarriedDecoration.Style = CarriedDecoration.Default.Style;
			CarriedDecoration.bUnlit = CarriedDecoration.Default.bUnlit;
			if (CarriedDecoration.IsA('DeusExDecoration'))
				DeusExDecoration(CarriedDecoration).ResetScaleGlow();

			CarriedDecoration = None;
		}
		else
		{
			// otherwise, don't drop it and display a message
			CarriedDecoration.SetLocation(origLoc);
			ClientMessage(CannotDropHere);
		}
	}
}


// ----------------------------------------------------------------------
// AddInventory()
// ----------------------------------------------------------------------

function bool AddInventory(Inventory Item)
{
	local Actor A;

	Log("AddInventory called " $ Item.Class);

	if (!Super.AddInventory(Item))
		return false;

	if (RootWindow != none && RootWindow.isA('HXRootWindow'))
		if (Item.isA('HXWeapon') || Item.isA('HXPickup'))
			HXRootWindow(RootWindow).Hud.Belt.AddObjectToBelt(Item, -1, false);

	// make sure nothing is based on us if we're an inventory
	foreach Item.BasedActors(class'Actor', A)
		A.SetBase(None);

	Item.SetBase(Self);

	return true;
}

// ----------------------------------------------------------------------
// PlayPickupAnim()
// ----------------------------------------------------------------------

function PlayPickupAnim(Vector locPickup)
{
	if (Location.Z - locPickup.Z < 16)
		PlayAnim('PushButton',,0.1);
	else
		PlayAnim('Pickup',,0.1);
}

// ----------------------------------------------------------------------
// UpdateInHand()
//
// Called every frame
// Checks the state of inHandPending and deals with animation and crap
// 1. Check for pending item
// 2. Play down anim (and deactivate) for inHand and wait for it to finish
// 3. Assign inHandPending to inHand (and SelectedItem)
// 4. Play up anim for inHand
// ----------------------------------------------------------------------

function UpdateInHand()
{
	local bool bSwitch;

	//sync up clientinhandpending.
	if (inHandPending != inHand)
		ClientInHandPending = inHandPending;

   //DEUS_EX AMSD  Don't let clients do this.
   if (Role < ROLE_Authority)
      return;

	if (inHand != inHandPending)
	{
		bInHandTransition = True;
		bSwitch = False;
		if (inHand != None)
		{
			// turn it off if it is on
			if (inHand.bActive)
				inHand.Activate();

			if (inHand.IsA('HXSkilledTool'))
			{
				if (inHand.IsInState('Idle'))
				{
					HXSkilledTool(inHand).PutDown();
        }
				else if (inHand.IsInState('Idle2'))
        {
					bSwitch = True;
        }
			}
			else if (inHand.IsA('HXWeapon'))
			{
				//if (inHand.IsInState('Idle') || inHand.IsInState('Reload'))
				if (inHand.IsInState('Idle') || inHand.IsInState('NewClip'))
					HXWeapon(inHand).PutDown();
				else if (inHand.IsInState('DownWeapon') && (Weapon == None))
					bSwitch = True;
			}
			else
			{
				bSwitch = True;
			}
		}
		else
		{
			bSwitch = True;
		}

		// OK to actually switch?
		if (bSwitch)
		{
			SetInHand(inHandPending);
			SelectedItem = inHandPending;

			if (inHand != None)
			{
				if (inHand.IsA('HXSkilledTool'))
					HXSkilledTool(inHand).BringUp();
				else if (inHand.IsA('HXWeapon'))
					SwitchWeapon(HXWeapon(inHand).InventoryGroup);
			}
		}
	}
	else
	{
		bInHandTransition = False;

		// Added this code because it's now possible to reselect an in-hand
		// item while we're putting it down, so we need to bring it back up...

		if (inHand != None)
		{
			// if we put the item away, bring it back up
			if (inHand.IsA('HXSkilledTool'))
			{
				if (inHand.IsInState('Idle2'))
					HXSkilledTool(inHand).BringUp();
			}
			else if (inHand.IsA('HXWeapon'))
			{
				if (inHand.IsInState('DownWeapon') && (Weapon == None))
					SwitchWeapon(DeusExWeapon(inHand).InventoryGroup);
			}
		}

	}

	//UpdateCarcassEvent();
}


// ----------------------------------------------------------------------
// SetInHand()
// ----------------------------------------------------------------------

function SetInHand(Inventory newInHand)
{
	local HXRootWindow root;

	inHand = newInHand;

	// Notify the hud
	root = HXRootWindow(rootWindow);
	if (root != None)
		root.hud.belt.UpdateInHand();
}


// ----------------------------------------------------------------------
// SetInHandPending()
// ----------------------------------------------------------------------

function SetInHandPending(Inventory newInHandPending)
{
	local HXRootWindow root;

	if ( newInHandPending == None )
		ClientInHandPending = None;

	inHandPending = newInHandPending;

	root = HXRootWindow(rootWindow);
	if (root != None)
		root.hud.belt.UpdateInHand();
}



// ----------------------------------------------------------------------
// state PlayerWalking
// ----------------------------------------------------------------------

state PlayerWalking
{
	// ProcessMove
	function ProcessMove (float DeltaTime, vector newAccel, eDodgeDir DodgeMove, rotator DeltaRot)
	{
		local int newSpeed, defSpeed;
		local name mat;
		local vector HitLocation, HitNormal, checkpoint, downcheck;
		local Actor HitActor, HitActorDown;
		local bool bCantStandUp;
		local Vector loc, traceSize;
		local float alpha, maxLeanDist;
		local float legTotal, weapSkill;


		defSpeed = GetCurrentGroundSpeed();

     // crouching makes you two feet tall
		if (bIsCrouching || bForceDuck)
		{
			SetBasedPawnSize(Default.CollisionRadius, 16);

			// check to see if we could stand up if we wanted to
			checkpoint = Location;
			// check normal standing height
			checkpoint.Z = checkpoint.Z - CollisionHeight + 2 * GetDefaultCollisionHeight();
			traceSize.X = CollisionRadius;
			traceSize.Y = CollisionRadius;
			traceSize.Z = 1;
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);
			if (HitActor == None)
				bCantStandUp = False;
			else
				bCantStandUp = True;
		}
		else
		{
         // DEUS_EX AMSD Changed this to grab defspeed, because GetCurrentGroundSpeed takes 31k cycles to run.
			GroundSpeed = defSpeed;

			// make sure the collision height is fudged for the floor problem - CNN
			if (!IsLeaning())
			{
				ResetBasedPawnSize();
			}
		}

		if (bCantStandUp)
			bForceDuck = True;
		else
			bForceDuck = False;

		// if the player's legs are damaged, then reduce our speed accordingly
		newSpeed = defSpeed;

		if (HealthLegLeft < 1)
			newSpeed -= (defSpeed/2) * 0.25;
		else if (HealthLegLeft < 34)
			newSpeed -= (defSpeed/2) * 0.15;
		else if (HealthLegLeft < 67)
			newSpeed -= (defSpeed/2) * 0.10;

		if (HealthLegRight < 1)
			newSpeed -= (defSpeed/2) * 0.25;
		else if (HealthLegRight < 34)
			newSpeed -= (defSpeed/2) * 0.15;
		else if (HealthLegRight < 67)
			newSpeed -= (defSpeed/2) * 0.10;

		if (HealthTorso < 67)
			newSpeed -= (defSpeed/2) * 0.05;

		// let the player pull themselves along with their hands even if both of
		// their legs are blown off
		if ((HealthLegLeft < 1) && (HealthLegRight < 1))
		{
			newSpeed = defSpeed * 0.8;
			bIsWalking = True;
			bForceDuck = True;
		}

		else if (bIsCrouching || bForceDuck)
			bIsWalking = True;

		// slow down player by weight of CarriedDecoration
		if (CarriedDecoration != None)
		{
			newSpeed -= CarriedDecoration.Mass * 2;
		}

		// i don't have a skill system for now...
		/*
		// don't slow the player down if he's skilled at the corresponding weapon skill
		else if ((DeusExWeapon(Weapon) != None) && (Weapon.Mass > 30) && (DeusExWeapon(Weapon).GetWeaponSkill() > -0.25) && (Level.NetMode==NM_Standalone))
		{
			bIsWalking = True;
			newSpeed = defSpeed;
		}
		*/

		// anyone would like to do animations/model for caried corpses? (abould 100...)
		//else if ((inHand != None) && inHand.IsA('POVCorpse'))
			//newSpeed -= inHand.Mass * 3;

		// if we are moving really slow, force us to walking
		if ((newSpeed <= defSpeed / 3) && !bForceDuck)
		{
			bIsWalking = True;
			newSpeed = defSpeed;
		}

		// if we are moving backwards, we should move slower
      // DEUS_EX AMSD Turns out this wasn't working right in multiplayer, I have a fix
      // for it, but it would change all our balance.
		if ((aForward < 0) && (Level.NetMode == NM_Standalone))
			newSpeed *= 0.65;

		GroundSpeed = FMax(newSpeed, 100);

		// if we are moving or crouching, we can't lean
		// uncomment below line to disallow leaning during crouch

		if ((VSize(Velocity) < 10) && (aForward == 0))		// && !bIsCrouching && !bForceDuck)
			bCanLean = True;
		else
			bCanLean = False;

		// check leaning buttons (axis aExtra0 is used for leaning)
		maxLeanDist = 40;

		if (IsLeaning())
		{
			if (!bIsCrouching && !bForceDuck)
				SetBasedPawnSize(CollisionRadius, GetDefaultCollisionHeight() - Abs(curLeanDist) / 3.0);
			if ( PlayerIsClient() || (Level.NetMode == NM_Standalone) )
			{
				ViewRotation.Roll = curLeanDist * 20;
				SetLocation( Location );
				SetRotation( ViewRotation );
				ServerUpdateLean( Location, ViewRotation );
			}
		}
		if (bCanLean && (aExtra0 != 0))
		{
			// lean
			DropDecoration();		// drop the decoration that we are carrying
			if (AnimSequence != 'CrouchWalk')
				PlayCrawling();

			alpha = maxLeanDist * aExtra0 * 2.0 * DeltaTime;

			loc = vect(0,0,0);
			loc.Y = alpha;
			if (Abs(curLeanDist + alpha) < maxLeanDist)
			{
				// check to make sure the destination not blocked
				checkpoint = (loc >> Rotation) + Location;
				traceSize.X = CollisionRadius;
				traceSize.Y = CollisionRadius;
				traceSize.Z = CollisionHeight;
				HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);

				// check down as well to make sure there's a floor there
				downcheck = checkpoint - vect(0,0,1) * CollisionHeight;
				HitActorDown = Trace(HitLocation, HitNormal, downcheck, checkpoint, True, traceSize);
				if ((HitActor == None) && (HitActorDown != None))
				{
					if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
					{
						SetLocation(checkpoint);
						SetRotation(Rotation);
						ServerUpdateLean( checkpoint, Rotation );
						curLeanDist += alpha;
					}
				}
			}
			else
			{
				if ( PlayerIsClient() || (Level.NetMode == NM_Standalone) )
					curLeanDist = aExtra0 * maxLeanDist;
			}
		}
		else if (IsLeaning())	//if (!bCanLean && IsLeaning())	// uncomment this to not hold down lean
		{
			// un-lean
			if (AnimSequence == 'CrouchWalk')
				PlayRising();

			if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
			{
				prevLeanDist = curLeanDist;
				alpha = FClamp(7.0 * DeltaTime, 0.001, 0.9);
				curLeanDist *= 1.0 - alpha;
				if (Abs(curLeanDist) < 1.0)
					curLeanDist = 0;
			}

			loc = vect(0,0,0);
			loc.Y = -(prevLeanDist - curLeanDist);

			// check to make sure the destination not blocked
			checkpoint = (loc >> Rotation) + Location;
			traceSize.X = CollisionRadius;
			traceSize.Y = CollisionRadius;
			traceSize.Z = CollisionHeight;
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);

			// check down as well to make sure there's a floor there
			downcheck = checkpoint - vect(0,0,1) * CollisionHeight;
			HitActorDown = Trace(HitLocation, HitNormal, downcheck, checkpoint, True, traceSize);
			if ((HitActor == None) && (HitActorDown != None))
			{
				if ( PlayerIsClient() || (Level.NetMode == NM_Standalone))
				{
					SetLocation(checkpoint);
					SetRotation(Rotation);
					ServerUpdateLean( checkpoint, Rotation );
				}
			}
		}

		Super.ProcessMove(DeltaTime, newAccel, DodgeMove, DeltaRot);
	}

	// ZoneChange()
	function ZoneChange(ZoneInfo NewZone)
	{
		// if we jump into water, empty our hands
		if (NewZone.bWaterZone)
			DropDecoration();

		Super.ZoneChange(NewZone);
	}

	// PlayerTick()
	event PlayerTick(float DeltaTime)
	{
		FrobTime += deltaTime;

		if (FrobTime >= 0.1)
		{
			UpdateFrobTarget();
			FrobTime = 0;
		}

		UpdateInHand();

		Super.PlayerTick(DeltaTime);
	}

}

function bool IsLeaning()
{
	return (curLeanDist != 0);
}


// ----------------------------------------------------------------------
// ResetBasedPawnSize()
// ----------------------------------------------------------------------

function bool ResetBasedPawnSize()
{
	return SetBasedPawnSize(Default.CollisionRadius, GetDefaultCollisionHeight());
}


// ----------------------------------------------------------------------
// GetCurrentGroundSpeed()
// ----------------------------------------------------------------------

function float GetCurrentGroundSpeed()
{
	local float augValue, speed;
/*
	// Remove this later and find who's causing this to Access None MB
	if ( AugmentationSystem == None )
		return 0;

   augValue = AugmentationSystem.GetAugLevelValue(class'AugSpeed');

	if (augValue == -1.0)
*/		augValue = 1.0;

	speed = Default.GroundSpeed * augValue;

	return speed;
}


// ----------------------------------------------------------------------
// SetBasedPawnSize()
// ----------------------------------------------------------------------

function bool SetBasedPawnSize(float newRadius, float newHeight)
{
	local float  oldRadius, oldHeight;
	local bool   bSuccess;
	local vector centerDelta, lookDir, upDir;
	local float  deltaEyeHeight;
	local Decoration savedDeco;

	if (newRadius < 0)
		newRadius = 0;
	if (newHeight < 0)
		newHeight = 0;

	oldRadius = CollisionRadius;
	oldHeight = CollisionHeight;

	if ( Level.NetMode == NM_Standalone )
	{
		if ((oldRadius == newRadius) && (oldHeight == newHeight))
			return true;
	}

	centerDelta    = vect(0, 0, 1)*(newHeight-oldHeight);
	deltaEyeHeight = GetDefaultCollisionHeight() - Default.BaseEyeHeight;

	if ( Level.NetMode != NM_Standalone )
	{
		if ((oldRadius == newRadius) && (oldHeight == newHeight) && (BaseEyeHeight == newHeight - deltaEyeHeight))
			return true;
	}

	if (CarriedDecoration != None)
		savedDeco = CarriedDecoration;

	bSuccess = false;
	if ((newHeight <= CollisionHeight) && (newRadius <= CollisionRadius))  // shrink
	{
		SetCollisionSize(newRadius, newHeight);
		if (Move(centerDelta))
			bSuccess = true;
		else
			SetCollisionSize(oldRadius, oldHeight);
	}
	else
	{
		if (Move(centerDelta))
		{
			SetCollisionSize(newRadius, newHeight);
			bSuccess = true;
		}
	}

	if (bSuccess)
	{
		// make sure we don't lose our carried decoration
		if (savedDeco != None)
		{
			savedDeco.SetPhysics(PHYS_None);
			savedDeco.SetBase(Self);
			savedDeco.SetCollision(False, False, False);

			// reset the decoration's location
			lookDir = Vector(Rotation);
			lookDir.Z = 0;
			upDir = vect(0,0,0);
			upDir.Z = CollisionHeight / 2;		// put it up near eye level
			savedDeco.SetLocation(Location + upDir + (0.5 * CollisionRadius + CarriedDecoration.CollisionRadius) * lookDir);
		}

//		PrePivotOffset  = vect(0, 0, 1)*(GetDefaultCollisionHeight()-newHeight);
		PrePivot        -= centerDelta;
//		DesiredPrePivot -= centerDelta;
		BaseEyeHeight   = newHeight - deltaEyeHeight;

/*
		// Complaints that eye height doesn't seem like your crouching in multiplayer
		if (( Level.NetMode != NM_Standalone ) && (bIsCrouching || bForceDuck) )
			EyeHeight		-= (centerDelta.Z * 2.5);
		else
*/
			EyeHeight		-= centerDelta.Z;


	}
	return (bSuccess);
}

// ----------------------------------------------------------------------
// HandleWalking()
//
// subclassed from PlayerPawn so we can control run/walk defaults
// ----------------------------------------------------------------------

function HandleWalking()
{
	Super.HandleWalking();

	if (bAlwaysRun)
		bIsWalking = (bRun != 0) || (bDuck != 0);
	else
		bIsWalking = (bRun == 0) || (bDuck != 0);

	// handle the toggle walk key
	if (bToggleWalk)
		bIsWalking = !bIsWalking;

	if (bToggleCrouch)
	{
		if (!bCrouchOn && !bWasCrouchOn && (bDuck != 0))
		{
			bCrouchOn = True;
		}
		else if (bCrouchOn && !bWasCrouchOn && (bDuck == 0))
		{
			bWasCrouchOn = True;
		}
		else if (bCrouchOn && bWasCrouchOn && (bDuck == 0) && (lastbDuck != 0))
		{
			bCrouchOn = False;
			bWasCrouchOn = False;
		}

		if (bCrouchOn)
		{
			bIsCrouching = True;
			bDuck = 1;
		}

		lastbDuck = bDuck;
	}
}

// ----------------------------------------------------------------------
// DoJump()
//
// copied from Engine.PlayerPawn
// Modified to let you jump if you are carrying something rather light
// You can also jump if you are crouching, just at a much lower height
// ----------------------------------------------------------------------

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ((CarriedDecoration != None) && (CarriedDecoration.Mass > 20))
		return;
	else if (bForceDuck || IsLeaning())
		return;

	if (Physics == PHYS_Walking)
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.2*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;
/*
		if ( Level.NetMode != NM_Standalone )
		{
         if (AugmentationSystem == None)
            augLevel = -1.0;
         else
            augLevel = AugmentationSystem.GetAugLevelValue(class'AugSpeed');
			w = DeusExWeapon(InHand);
			if ((augLevel != -1.0) && ( w != None ) && ( w.Mass > 30.0))
			{
				scaleFactor = 1.0 - FClamp( ((w.Mass - 30.0)/55.0), 0.0, 0.5 );
				Velocity.Z *= scaleFactor;
			}
		}
*/
		// reduce the jump velocity if you are crouching
//		if (bIsCrouching)
//			Velocity.Z *= 0.9;

		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}
}


// ----------------------------------------------------------------------
// GetDefaultCollisionHeight()
// ----------------------------------------------------------------------

function float GetDefaultCollisionHeight()
{
	return (Default.CollisionHeight-4.5);
}


function ServerUpdateLean( Vector loc, Rotator rot )
{
	SetLocation( loc );
	SetRotation( rot );
}


// ----------------------------------------------------------------------
// PutInHand()
//
// put the object in the player's hand and draw it in front of the player
// ----------------------------------------------------------------------

exec function PutInHand(optional Inventory inv)
{
	if (RestrictInput())
		return;

	// can't put anything in hand if you're using a spy drone
//	if ((inHand == None) && bSpyDroneActive)
//		return;

	// can't do anything if you're carrying a corpse
//	if ((inHand != None) && inHand.IsA('POVCorpse'))
//		return;

	if (inv != None)
	{
		// can't put ammo in hand
		if (inv.IsA('Ammo'))
			return;

		// Can't put an active charged item in hand
		if ((inv.IsA('ChargedPickup')) && (ChargedPickup(inv).IsActive()))
			return;
	}

	if (CarriedDecoration != None)
		DropDecoration();

	SetInHandPending(inv);
}


// ----------------------------------------------------------------------
// RestrictInput()
//
// Are we in a state which doesn't allow certain exec functions?
// ----------------------------------------------------------------------

function bool RestrictInput()
{
	if (IsInState('Interpolating') || IsInState('Dying') || IsInState('Paralyzed'))
		return True;

	return False;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     MenuThemeName="Default"
     HUDThemeName="Default"
     bHUDBordersVisible=True
     bHUDBordersTranslucent=True
     bHUDBackgroundTranslucent=True
     bMenusTranslucent=True
     logTimeout=3.000000
     bObjectNames=True
     bSubtitles=True
     bAlwaysRun=True
     bHelpMessages=True
     bAutoReload=True
     bHUDShowAllAugs=True
     bCrosshairVisible=True
     bHitDisplayVisible=True
     bCompassVisible=True
     bObjectBeltVisible=True
     bAmmoDisplayVisible=True
     MaxFrobDistance=112.000000
     Energy=100.000000
     EnergyMax=100.000000
     InventoryFull="You don't have enough room in your inventory to pick up the %s"
     TooMuchAmmo="You already have enough of that type of ammo"
     TooHeavyToLift="It's too heavy to lift"
     CannotLift="You can't lift that"
     NoRoomToLift="There's no room to lift that"
     CanCarryOnlyOne="You can only carry one %s"
     CannotDropHere="Can't drop that here"
     HandsFull="Your hands are full"
     NoteAdded="Note Received - Check DataVault For Details"
     GoalAdded="Goal Received - Check DataVault For Details"
     PrimaryGoalCompleted="Primary Goal Completed"
     SecondaryGoalCompleted="Secondary Goal Completed"
     EnergyDepleted="Bio-electric energy reserves depleted"
     HealedPointsLabel="Healed %d points"
     HealedPointLabel="Healed %d point"
     SkillPointsAward="%d skill points awarded"
     QuickSaveGameTitle="Quick Save"
     WeaponUnCloak="Weapon drawn... Uncloaking"
     TakenOverString="I've taken over the "
     HeadString="Head"
     TorsoString="Torso"
     LegsString="Legs"
     WithTheString=" with the "
     WithString=" with "
     PoisonString=" with deadly poison"
     BurnString=" with excessive burning"
     NoneString="None"
     DrawType=DT_Mesh
}
