//=============================================================================
// HXRootWindow.
//=============================================================================
class HXRootWindow expands RootWindow;

var ColorThemeManager ThemeManager;
var HXHUD Hud;
var bool	bUIPaused;

var private HXMenuUIWindow Menus[8];
var private int CurrentMenu;

var HXPlayerPawn Player;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	Player = HXPlayerPawn(ParentPawn);

	CreateColorThemeManager();

	Hud = HXHUD(NewChild(Class'HXHUD'));
	Hud.UpdateSettings(HXPlayerPawn(parentPawn));
	Hud.SetWindowAlignments(HALIGN_Full, VALIGN_Full, 0, 0);

	SetDefaultCursor(Texture'DeusExCursor1', Texture'DeusExCursor1_Shadow');

	UpdateHudVisibility();
}

// ----------------------------------------------------------------------
// DescendantRemoved()
// ----------------------------------------------------------------------

event DescendantRemoved(Window Descendant)
{
	if (Descendant == Hud)
		Hud = None;
}


// ----------------------------------------------------------------------
// ClientMessage()
// ----------------------------------------------------------------------

function bool ClientMessage(coerce string msg, optional Name Type,
                           optional bool bBeep)
{
	local Color linecol;

	linecol.R = 255; linecol.G = 255; linecol.B = 255;

	// Add this to the player's list of log objects
	//DeusExPlayer(parentPawn).AddLog(msg);

	if (ParentPawn.Level.NetMode != NM_Standalone)
	{
		if (Type == 'Say')
			PlaySound(Sound'Menu_Incoming', 0.5);
		else if ( Type == 'TeamSay' )
			PlaySound(Sound'Menu_IncomingFriend', 0.5);

		if (!Hud.bIsVisible)
		{
			if (parentPawn.Player.Console != None)
			{
				parentPawn.Player.Console.AddString(msg);
				return True;
			}
		}
	}
	if ((Hud != None) && (Hud.LogDisplay != None))
	{
		// Display in the HUD
		if (ParentPawn.Level.NetMode != NM_Standalone)
		{
			switch (type)
			{
				case 'TeamSay':
					linecol.R = 0; linecol.G = 255; linecol.B = 0;
					break;
				case 'Say':
					linecol.R = 255; linecol.G = 255; linecol.B = 255;
					break;
				default:
					//default to sp colors...
					//linecol.R = 200; linecol.G = 200; linecol.B = 200;
					break;
			}
			Hud.LogDisplay.AddLog(msg, linecol);
		}
		else
			Hud.LogDisplay.AddLog(msg, linecol);
		
		return True;
	}
	else
	{
		return False;
	}
}


// ----------------------------------------------------------------------
// CreateThemeManager()
// ----------------------------------------------------------------------

function CreateColorThemeManager()
{
	if (ThemeManager == None)
	{
		ThemeManager = Player.Spawn(Class'ColorThemeManager', Player);

		// Menus
		ThemeManager.AddTheme(Class'ColorThemeMenu_Default');
		ThemeManager.AddTheme(Class'ColorThemeMenu_BlueAndGold');
		ThemeManager.AddTheme(Class'ColorThemeMenu_CoolGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Cops');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Cyan');
		ThemeManager.AddTheme(Class'ColorThemeMenu_DesertStorm');
		ThemeManager.AddTheme(Class'ColorThemeMenu_DriedBlood');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Dusk');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Earth');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Green');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Grey');
		ThemeManager.AddTheme(Class'ColorThemeMenu_IonStorm');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Lava');
		ThemeManager.AddTheme(Class'ColorThemeMenu_NightVision');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Ninja');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Olive');
		ThemeManager.AddTheme(Class'ColorThemeMenu_PaleGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Pastel');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Plasma');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Primaries');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Purple');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Red');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Seawater');
		ThemeManager.AddTheme(Class'ColorThemeMenu_SoylentGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Starlight');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Steel');
		ThemeManager.AddTheme(Class'ColorThemeMenu_SteelGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Superhero');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Terminator');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Violet');

		// HUD
		ThemeManager.AddTheme(Class'ColorThemeHUD_Default');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Amber');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Cops');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Cyan');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DarkBlue');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DesertStorm');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DriedBlood');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Dusk');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Grey');
		ThemeManager.AddTheme(Class'ColorThemeHUD_IonStorm');
		ThemeManager.AddTheme(Class'ColorThemeHUD_NightVision');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Ninja');
		ThemeManager.AddTheme(Class'ColorThemeHUD_PaleGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Pastel');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Plasma');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Primaries');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Purple');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Red');
		ThemeManager.AddTheme(Class'ColorThemeHUD_SoylentGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Starlight');
		ThemeManager.AddTheme(Class'ColorThemeHUD_SteelGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Superhero');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Terminator');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Violet');
	}

	ThemeManager.SetOwner(HXPlayerPawn(parentPawn));
	ThemeManager.SetCurrentHUDColorTheme(ThemeManager.GetFirstTheme(1));
	ThemeManager.SetCurrentMenuColorTheme(ThemeManager.GetFirstTheme(0));

	if (Player.MenuThemeName != "")
		ThemeManager.SetMenuThemeByName(Player.MenuThemeName);
	if (Player.HUDThemeName != "")
		ThemeManager.SetHUDThemeByName(Player.HUDThemeName);

	ChangeStyle();
}


// ----------------------------------------------------------------------
// OpenMenu()
// ----------------------------------------------------------------------

function HXMenuUIWindow OpenMenu(Class<HXMenuUIWindow> MenuClass)
{
	local HXMenuUIWindow NewWin;

	// maximum menu level reaching (this should never happen)
	if (CurrentMenu > 7 || MenuClass == None)
		return None;

	
	if (MenuClass != Class'HXMenuUIMessageBoxWindow')
	{
		// hide hud
		Hud.Hide();

		// no other menu
		if (CurrentMenu != -1)
			Menus[CurrentMenu].Hide();
	}

	Menus[++CurrentMenu] = HXMenuUIWindow(NewChild(MenuClass, true));

	return Menus[CurrentMenu];
}


// ----------------------------------------------------------------------
// CloseTopMenu()
// ----------------------------------------------------------------------

function bool CloseTopMenu()
{
	if (CurrentMenu == -1)
		return false;
	
	// kill kill kill
	Menus[CurrentMenu].Hide();
	Menus[CurrentMenu].Destroy();
	Menus[CurrentMenu] = None;

	if (--CurrentMenu > -1)
		Menus[CurrentMenu].Show();

	UpdateHudVisibility();
}


// ----------------------------------------------------------------------
// CloseTopWindow()
// ----------------------------------------------------------------------

function bool CloseTopWindow()
{
	if (CurrentMenu != -1)
		return CloseTopMenu();

}



// ----------------------------------------------------------------------
// CloseAllWindows()
// ----------------------------------------------------------------------

function CloseAllWindows()
{
	while (CloseTopMenu());
}




// ----------------------------------------------------------------------
// OpenMessageBox()
// ----------------------------------------------------------------------

function HXMenuUIMessageBoxWindow OpenMessageBox(string Title, string Text, int Mode, Window Win)	
{
	local HXMenuUIMessageBoxWindow Box;

	Box = HXMenuUIMessageBoxWindow(OpenMenu(Class'HXMenuUIMessageBoxWindow'));
	Box.SetTitle(Title);
	Box.SetMessageText(Text);
	Box.SetMode(Mode);
	Box.SetNotifyWindow(Win);

	return Box;
}


// ----------------------------------------------------------------------
// ExitGame()
// ----------------------------------------------------------------------

function ExitGame()
{
	//ClearWindowStack();
	// TODO: destroy all windows...

	ParentPawn.ConsoleCommand("Exit");
}


// ----------------------------------------------------------------------
// UpdateHudVisibility()
// ----------------------------------------------------------------------

function UpdateHudVisibility()
{
	if (CurrentMenu != -1 || Player.GetURLMap() ~= "DX.dx")
		Hud.Hide();
	else
		Hud.Show();
}

// ----------------------------------------------------------------------
// MaskBackground()
// ----------------------------------------------------------------------

function MaskBackground(bool bMask)
{
	if (bMask)
	{
		SetBackground(Texture'MaskTexture');
		SetBackgroundStyle(DSTY_Modulated);
		//ShowHud(False);
		Hud.Hide();
	}
	else
	{
		SetBackground(None);
		SetBackgroundStyle(DSTY_None);
		//ShowHud(True);	
		Hud.Show();
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     CurrentMenu=-1
}
