//=============================================================================
// HXWeapon
//=============================================================================
class HXWeapon extends Weapon
	abstract;

enum EEnemyEffective
{
	ENMEFF_All,
	ENMEFF_Organic,
	ENMEFF_Robot
};

enum EEnviroEffective
{
	ENVEFF_All,
	ENVEFF_Air,
	ENVEFF_Water,
	ENVEFF_Vacuum,
	ENVEFF_AirWater,
	ENVEFF_AirVacuum,
	ENVEFF_WaterVacuum
};

enum ESkillEffective
{
	SKLEFF_Demolition,
	SKLEFF_Heavy,
	SKLEFF_LowTech,
	SKLEFF_Pistol,
	SKLEFF_Rifle
};


var EEnemyEffective		EnemyEffective;		// type of enemies that weapon is effective against
var EEnviroEffective	EnviroEffective;	// type of environment that weapon is effective in
var ESkillEffective		SkillEffective;		// type of Skill this weapon is affected by

var float NoiseLevel;
var float ShotTime;
var float	ReloadTime;
var int		LowAmmoWaterMark;
var int		HitDamage;
var int		MaxRange;

// tracker for bullets in clip
var int ClipCount;

var bool bWasInFiring;
var bool bClientReadyToFire;
var bool bHasMuzzleFlash;
var bool bPenetrating;
var name DamageType;

// ----------------------------------------------------------------------
// state Idle
// ----------------------------------------------------------------------

state Idle
{
	function AnimEnd()
	{
		PlayIdleAnim();
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}

	function Timer()
	{
		PlayIdleAnim();
	}

Begin:
	bPointing=False;

	Disable('AnimEnd');
	PlayIdleAnim();

	SetTimer(3.0, True);

	if (Pawn(Owner).bFire !=0)
		Global.Fire(0.0);
}




// ----------------------------------------------------------------------
// state Pickup
// ----------------------------------------------------------------------

auto state Pickup
{
	// When touched by an actor.
	// Now, when frobbed by an actor - DEUS_EX CNN
	function Frob(Actor Other, Inventory frobWith)
	{
		// If touched by a player pawn, let him pick this up.
		if( ValidTouch(Other) )
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));

			SpawnCopy(Pawn(Other));

			// notice client of pickup
			PlaySound(PickupSound);
			if ( PickupMessageClass == None )
				Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
			else
				Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );

			if (Level.Game.Difficulty > 1)
				Other.MakeNoise(0.1 * Level.Game.Difficulty);
			if (Pawn(Other).MoveTarget == self)
				Pawn(Other).MoveTimer = -1.0;		
		}
		/*
		else if ( bTossedOut && (Other.Class == Class)
				&& Inventory(Other).bTossedOut )
				Destroy();
		*/
	}
}


// ----------------------------------------------------------------------
// ProcessTraceHit()
// ----------------------------------------------------------------------

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local Rotator Rot;

	if (Other == None)
		return;

	if (Role == ROLE_Authority)
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 1000.0*X, DamageType);

	if ((Other != self) && (Other != Owner))
		if (bPenetrating && Other.IsA('Pawn') && !Other.IsA('Robot'))
			SpawnBlood(HitLocation, HitNormal);
}



//
//	SpawnEffects - Spawns the effects like it did in single player
//

function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
	local TraceHitSpawner hitspawner;

	if (bPenetrating)
	{
		// HACK - move
		if (Self.isA('HXWeaponMelee'))
			hitspawner = Spawn(class'TraceHitHandSpawner',Other,,HitLocation,Rotator(HitNormal));
		else
			hitspawner = Spawn(class'TraceHitSpawner',Other,,HitLocation,Rotator(HitNormal));
	}
	else
	{
		// HACK - move
		if (Self.isA('HXWeaponMelee'))
			hitspawner = Spawn(class'TraceHitHandNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
		else
			hitspawner = Spawn(class'TraceHitNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));

	}
	if (hitSpawner != None)
	{
		hitspawner.HitDamage = Damage;
		hitSpawner.damageType = damageType;
	}
/*
// HACK - move
	if (Self.isA('HXWeaponMelee'))
	{
		// if we are hand to hand, play an appropriate sound
		if (Other.IsA('DeusExDecoration'))
			Owner.PlaySound(Misc3Sound, SLOT_None,,, 1024);
		else if (Other.IsA('Pawn'))
			Owner.PlaySound(Misc1Sound, SLOT_None,,, 1024);
		else if (Other.IsA('BreakableGlass'))
			Owner.PlaySound(sound'GlassHit1', SLOT_None,,, 1024);
		else if (GetWallMaterial(HitLocation, HitNormal) == 'Glass')
			Owner.PlaySound(sound'BulletProofHit', SLOT_None,,, 1024);
		else
			Owner.PlaySound(Misc2Sound, SLOT_None,,, 1024);
	}
*/
}


//
// SpawnBlood
//

function SpawnBlood(Vector HitLocation, Vector HitNormal)
{
//   if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
//      return;

	spawn(class'BloodSpurt',,,HitLocation+HitNormal);
	spawn(class'BloodDrop',,,HitLocation+HitNormal);

	if (FRand() < 0.5)
		spawn(class'BloodDrop',,,HitLocation+HitNormal);
}

// ----------------------------------------------------------------------
// PlayIdleAnim()
// ----------------------------------------------------------------------

function PlayIdleAnim()
{
	local float rnd;

	rnd = FRand();

	if			(rnd < 0.1) PlayAnim('Idle1',,0.1);
	else if (rnd < 0.2) PlayAnim('Idle2',,0.1);
	else if (rnd < 0.3) PlayAnim('Idle3',,0.1);
}


function int AmmoLeftInClip()
{
	if (ReloadCount == 0)	// if this weapon is not reloadable
		return 1;
	else if (AmmoType == None)
		return 0;
	else if (AmmoType.AmmoAmount == 0)		// if we are out of ammo
		return 0;
	else if (ReloadCount - ClipCount > AmmoType.AmmoAmount)		// if we have no clips left
		return AmmoType.AmmoAmount;
	else
		return ReloadCount - ClipCount;
}

function int NumClips()
{
	if (ReloadCount == 0)  // if this weapon is not reloadable
		return 0;
	else if (AmmoType == None)
		return 0;
	else if (AmmoType.AmmoAmount == 0)	// if we are out of ammo
		return 0;
	else  // compute remaining clips
		return ((AmmoType.AmmoAmount-AmmoLeftInClip()) + (ReloadCount-1)) / ReloadCount;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     NoiseLevel=1.000000
     ShotTime=0.500000
     reloadTime=1.000000
     LowAmmoWaterMark=10
     HitDamage=10
     bHasMuzzleFlash=True
     bPenetrating=True
     ReloadCount=10
     shakevert=10.000000
     Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
     AutoSwitchPriority=0
     bRotatingPickup=False
     PickupMessage="You found"
     ItemName="DEFAULT WEAPON NAME - REPORT THIS AS A BUG"
     LandSound=Sound'DeusExSounds.Generic.DropSmallWeapon'
     bNoSmooth=False
     Mass=10.000000
     Buoyancy=5.000000
}
