//=============================================================================
// HXWeaponMelee - base class for melee weapons
//=============================================================================
class HXWeaponMelee extends HXWeapon
	abstract;

// ----------------------------------------------------------------------
// ProcessTraceHit()
// ----------------------------------------------------------------------

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local Rotator Rot;

	if (Other == None)
		return;

	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);

	if ((Other == Level) || (Other.IsA('Mover')))
		SpawnEffects(HitLocation, HitNormal, Other, HitDamage);

	SpawnEffects(HitLocation, HitNormal, Other, HitDamage);

}

//		if (Self.isA('HXWeaponMelee'))
//			

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     SkillEffective=SKLEFF_LowTech
}
