//=============================================================================
// HXWeaponProjectile - base class for projectile weapons
//=============================================================================
class HXWeaponProjectile extends HXWeapon
	abstract;

// weapon abilities
var bool bCanHaveModAccuracy;
var bool bCanHaveModClip;
var bool bCanHaveModLaser;
var bool bCanHaveModRange;
var bool bCanHaveModRecoil;
var bool bCanHaveModReload;
var bool bCanHaveModScope;
var bool bCanHaveModSilencer;

var int		ModScopeFOV;
var int		AccurateRange;

var float	BaseAccuracy;
var float	RecoilStrength;


// keep track of applied mods
var bool bHasLaser;
var bool bHasScope;
var bool bHasSilencer;

var int ModCountAccuracy;
var int ModCountClip;
var int ModCountRange;
var int ModCountRecoil;
var int ModCountReload;


var bool bLaserOn;
var bool bScopeOn;
var bool bUseWhileCrouched;

// ----------------------------------------------------------------------
// Reload()
// ----------------------------------------------------------------------

function Reload()
{
	GotoState('NewClip');
}


// ----------------------------------------------------------------------
// ToggleScope()
// ----------------------------------------------------------------------

function ToggleScope()
{
	if (!bHasScope)
		return;

	// TODO: zoom in/out

	bScopeOn = !bScopeOn;
}

// ----------------------------------------------------------------------
// ToggleLaser()
// ----------------------------------------------------------------------

function ToggleLaser()
{
	if (!bHasLaser)
		return;

	// TODO: show/hide laser

	bLaserOn = !bLaserOn;
}


// ----------------------------------------------------------------------
// PlayFiring()
// ----------------------------------------------------------------------

function Fire(float Value)
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayFiring();

		if (!bRapidFire && (FiringSpeed > 0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if (bInstantHit)
			TraceFire(0.0);
		else
			ProjectileFire(ProjectileClass, CalcProjSpeed(), False);

		if ( Owner.bHidden )
			CheckVisibility();
	}
}


// ----------------------------------------------------------------------
// PlayFiring()
// ----------------------------------------------------------------------

function PlayFiring()
{
	ClipCount++;
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
}




// ----------------------------------------------------------------------
// state NormalFire
// ----------------------------------------------------------------------

state NormalFire
{
Begin:
	if (AnimSequence != 'Shoot0') 
	{
		PlayAnim('Shoot',2.5, 0.02);
		FinishAnim();
	}

	PlayAnim('Shoot0',0.26, 0.04);	
	FinishAnim();

	Sleep(CalcShotTime());
	//if (ClipCount > 15) 
		//Owner.PlaySound(Misc1Sound, SLOT_None, 3.5*Pawn(Owner).SoundDampening);

	if (bChangeWeapon)
		GotoState('DownWeapon');
	
	else if (PlayerPawn(Owner) == None)
		Super.Finish();
	
	else if ((AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self))
		GotoState('Idle');
	
	else if (Pawn(Owner).bFire != 0)
		Global.Fire(0);

	PlayAnim('Shoot2',0.8, 0.0);	
	FinishAnim();

	GoToState('Idle');
}

// ----------------------------------------------------------------------
// state NewClip
// ----------------------------------------------------------------------

state NewClip
{
ignores Fire;
Begin:
	//PlayAnim('Eject',1.5,0.05);
	PlayAnim('ReloadBegin');

	FinishAnim();
	LoopAnim('Reload');
	Sleep(CaltReloadTime());
	Owner.PlaySound(AltFireSound, SLOT_None,,, 1024);
	PlayAnim('ReloadEnd');
	FinishAnim();

	ClipCount = 0;

//	PlayAnim('Select',1.6,0.07);
//	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else GotoState('Idle');
}


// ----------------------------------------------------------------------
// ProcessTraceHit()
// ----------------------------------------------------------------------

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local HXPlayerPawn Player;
	local Rotator Rot;
	local float Recoil;

	if (Other == None)
		return;

	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);

	if ((Other == Level) || (Other.IsA('Mover')))
		SpawnEffects(HitLocation, HitNormal, Other, HitDamage);
}



// ----------------------------------------------------------------------
// PlayPostSelect()
// ----------------------------------------------------------------------

function PlayPostSelect()
{
	ClipCount = 0;
}


// ----------------------------------------------------------------------
// Finish()
// ----------------------------------------------------------------------

function Finish()
{
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (ClipCount >= GalcClipMax())
		GoToState('NewClip');
	else if (Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else 
		GotoState('Idle');
}



function int GalcClipMax()
{
	// TODO add mod effect
	return ReloadCount;
}


function float CalcProjSpeed()
{
	// TODO add mod effect
	ProjectileSpeed = ProjectileClass.Default.Speed;
	return ProjectileSpeed;
}

function float CalcRecoil()
{
	local float Recoil;

	Recoil = RecoilStrength;

	if (Recoil < 0.0)
		return 0.0;

	return Recoil;
}

function float CaltReloadTime()
{
	local float rtime;

	rtime = ReloadTime;

	return rtime;
}

function float CalcShotTime()
{
	return ShotTime;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     ModScopeFOV=10
     BaseAccuracy=0.500000
     bUseWhileCrouched=True
     maxRange=9600
     DamageType='
     bInstantHit=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     ProjectileClass=Class'DeusEx.Tracer'
     shakemag=200.000000
     shakevert=4.000000
     AIRating=0.200000
     RefireRate=0.700000
}
