/*=============================================================================
	HXGameEngine.h: Header file for HXGameEngine

=============================================================================*/

#ifndef _HX_GAME_ENGINE_
#define _HX_GAME_ENGINE_


/*------------------------------------------------------------------------------------
	Declaration.
------------------------------------------------------------------------------------*/

class HXCOOP_API UHXGameEngine : public DDeusExGameEngine
{
DECLARE_CLASS(UHXGameEngine, DDeusExGameEngine, CLASS_Config|CLASS_Transient);

public:

	void DeleteGame(INT Position)
	{
		guard(UHXGameEngine::DeleteGame);

		GLog->Log(TEXT("(II) UHXGameEngine::DeleteGame() called"));
		DDeusExGameEngine::DeleteGame(Position);

		unguard;
	};

	UDeusExSaveInfo* GetSaveInfo(UPackage *saveInfoPackage)
	{
		guard(UHXGameEngine::GetSaveInfo);

		GLog->Log(TEXT("(II) UHXGameEngine::GetSaveInfo() called"));
		return DDeusExGameEngine::GetSaveInfo(saveInfoPackage);

		unguard;
	};

	void CopySaveGameFiles(FString &source, FString &dest)
	{
		guard(UHXGameEngine::CopySaveGameFiles);

		GLog->Log(TEXT("(II) UHXGameEngine::CopySaveGameFiles() called"));
		DDeusExGameEngine::CopySaveGameFiles(source, dest);

		unguard;
	}

	void DeleteSaveGameFiles(FString saveDirectory = TEXT(""))
	{
		guard(UHXGameEngine::DeleteSaveGameFiles);

		GLog->Log(TEXT("(II) UHXGameEngine::DeleteSaveGameFiles() called"));
		DDeusExGameEngine::DeleteSaveGameFiles(saveDirectory);

		unguard;
	}

	UDeusExSaveInfo* LoadSaveInfo(int DirectoryIndex = -2)
	{
		guard(UHXGameEngine::LoadSaveInfo);

		GLog->Log(TEXT("(II) UHXGameEngine::LoadSaveInfo() called"));
		return DDeusExGameEngine::LoadSaveInfo(DirectoryIndex);

		unguard;
	}

	void PruneTravelActors(void)
	{
		guard(UHXGameEngine::PruneTravelActors);

		GLog->Log(TEXT("(II) UHXGameEngine::PruneTravelActors() called"));
		DDeusExGameEngine::PruneTravelActors();

		unguard;
	};

	void SaveCurrentLevel(int DirectoryIndex = -2, bool bSavePlayer = FALSE)
	{
		guard(UHXGameEngine::SaveCurrentLevel);

		GLog->Log(TEXT("(II) UHXGameEngine::SaveCurrentLevel() called"));
		DDeusExGameEngine::SaveCurrentLevel(DirectoryIndex, bSavePlayer);		

		unguard;
	};

	INT GetCurrentMissionNumber(void)
	{
		guard(UHXGameEngine::GetCurrentMissionNumber);

		GLog->Log(TEXT("(II) UHXGameEngine::GetCurrentMissionNumber() called"));
		return DDeusExGameEngine::GetCurrentMissionNumber();

		unguard;
	};

	INT GetNextMissionNumber(FString &mapName)
	{
		guard(UHXGameEngine::GetNextMissionNumber);

		GLog->Log(TEXT("(II) UHXGameEngine::GetNextMissionNumber() called"));
		return DDeusExGameEngine::GetNextMissionNumber(mapName);

		unguard;
	};

	ADeusExLevelInfo* GetDeusExLevelInfo(void)
	{
		guard(UHXGameEngine::GetDeusExLevelInfo);

		GLog->Log(TEXT("(II) UHXGameEngine::GetDeusExLevelInfo() called"));
		return DDeusExGameEngine::GetDeusExLevelInfo();

		unguard;
	};


	void Init(void)
	{
		guard(UHXGameEngine::Init);

		GLog->Log(TEXT("(II) UHXGameEngine::Init() called"));
		DDeusExGameEngine::Init();

		unguard;
	};
	
	UBOOL Exec(const TCHAR* Cmd, FOutputDevice& Ar=*GLog)
	{
		guard(UHXGameEngine::Exec);

		//GLog->Log(TEXT("(II) UHXGameEngine::Exec() called"));
		//GLog->Log(Cmd);
		return DDeusExGameEngine::Exec(Cmd, Ar);

		unguard;
	};

	void SaveGame(INT Position, FString saveDesc = TEXT(""))
	{
		guard(UHXGameEngine::SaveGame);

		GLog->Log(TEXT("(II) UHXGameEngine::SaveGame() called"));
		DDeusExGameEngine::SaveGame(Position, saveDesc);

		unguard;
	};


	UBOOL Browse(FURL URL, const TMap<FString,FString>* TravelInfo, FString& Error)
	{
		guard(UHXGameEngine::Browse);

		GLog->Log( TEXT("(II) UHXGameEngine::Browse() called"));
		GLog->Log( TEXT("(II) Parameter:"));
		GLog->Logf(TEXT("(II)   URL.Protocol: %s"), URL.Protocol);
		GLog->Logf(TEXT("(II)   URL.Host:     %s"), URL.Host);
		GLog->Logf(TEXT("(II)   URL.Port:     %i"), URL.Port);
		GLog->Logf(TEXT("(II)   URL.Map:      %s"), URL.Map);
		GLog->Logf(TEXT("(II)   URL.Portal:   %s"), URL.Portal);

		// hacks...
		if (URL.Host == TEXT("0.0.0.0"))
		{
			URL.Host = FString(TEXT(""));
			GLog->Log(TEXT("(II) Fixed URL (0.0.0.0)"));
		}

		return DDeusExGameEngine::Browse(URL, TravelInfo, Error);

		unguard;
	};

};


#endif // _HXCOOP_GAME_ENGINE_

/*------------------------------------------------------------------------------------
	The End.
------------------------------------------------------------------------------------*/
