/*=============================================================================
	HXGameInfo.cpp: HXGameInfo implementation.

=============================================================================*/

/*------------------------------------------------------------------------------------
	Dependencies.
------------------------------------------------------------------------------------*/

#include "HXCoopPrivate.h"

/*------------------------------------------------------------------------------------
	Implementation.
------------------------------------------------------------------------------------*/

IMPLEMENT_CLASS(AHXGameInfo);


// EngineSaveGame()
IMPLEMENT_FUNCTION(AHXGameInfo,2320,execEngineSaveGame);

void AHXGameInfo::execEngineSaveGame(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineSaveGame);

	P_GET_INT(Position);
	P_GET_STR_OPTX(saveDesc, TEXT(""));
	P_FINISH;
	
	((UHXGameEngine *)GetLevel()->Engine)->SaveGame(Position, saveDesc);

	unguardexec;
}


// EngineGetDeusExLevelInfo()
IMPLEMENT_FUNCTION(AHXGameInfo,2319,execEngineGetDeusExLevelInfo);

void AHXGameInfo::execEngineGetDeusExLevelInfo(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineGetDeusExLevelInfo);

	P_FINISH;

	*(ADeusExLevelInfo **)Result = ((UHXGameEngine *)GetLevel()->Engine)->GetDeusExLevelInfo();

	unguardexec;
}


// EngineGetNextMissionNumber()
IMPLEMENT_FUNCTION(AHXGameInfo,2318,execEngineGetNextMissionNumber);

void AHXGameInfo::execEngineGetNextMissionNumber(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineGetNextMissionNumber);

	P_GET_STR(mapName)
	P_FINISH;

	*(DWORD *)Result = ((UHXGameEngine *)GetLevel()->Engine)->GetNextMissionNumber(mapName);

	unguardexec;
}


// EngineGetCurrentMissionNumber()
IMPLEMENT_FUNCTION(AHXGameInfo,2317,execEngineGetCurrentMissionNumber);

void AHXGameInfo::execEngineGetCurrentMissionNumber(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineGetCurrentMissionNumber);

	P_FINISH;

	*(DWORD *)Result = ((UHXGameEngine *)GetLevel()->Engine)->GetCurrentMissionNumber();

	unguardexec;
}


// EngineSaveCurrentLevel()
IMPLEMENT_FUNCTION(AHXGameInfo,2316,execEngineSaveCurrentLevel);

void AHXGameInfo::execEngineSaveCurrentLevel(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineSaveCurrentLevel);

	P_GET_INT_OPTX(DirectoryIndex, -2);
	P_GET_UBOOL_OPTX(bSavePlayer, FALSE)
	P_FINISH;

	((UHXGameEngine *)GetLevel()->Engine)->SaveCurrentLevel(DirectoryIndex, bSavePlayer == FALSE ? false : true);

	unguardexec;
}


// EnginePruneTravelActors()
IMPLEMENT_FUNCTION(AHXGameInfo,2315,execEnginePruneTravelActors);

void AHXGameInfo::execEnginePruneTravelActors(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEnginePruneTravelActors);

	P_FINISH;

	((UHXGameEngine *)GetLevel()->Engine)->PruneTravelActors();

	unguardexec;
}


// EngineLoadSaveInfo()
IMPLEMENT_FUNCTION(AHXGameInfo,2314,execEngineLoadSaveInfo);
void AHXGameInfo::execEngineLoadSaveInfo(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineLoadSaveInfo);

	P_GET_INT_OPTX(DirectoryIndex, -2);
	P_FINISH;

	*(UDeusExSaveInfo **)Result = ((UHXGameEngine *)GetLevel()->Engine)->LoadSaveInfo(DirectoryIndex);

	unguardexec;
}


// EngineDeleteSaveGameFiles()
IMPLEMENT_FUNCTION(AHXGameInfo,2313,execEngineDeleteSaveGameFiles);
void AHXGameInfo::execEngineDeleteSaveGameFiles(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineDeleteSaveGameFiles);

	P_GET_STR_OPTX(saveDirectory, TEXT(""));
	P_FINISH;

	((UHXGameEngine *)GetLevel()->Engine)->DeleteSaveGameFiles(saveDirectory);

	unguardexec;
}


// EngineCopySaveGameFiles()
IMPLEMENT_FUNCTION(AHXGameInfo,2312,execEngineCopySaveGameFiles);
void AHXGameInfo::execEngineCopySaveGameFiles(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineCopySaveGameFiles);

	P_GET_STR(source);
	P_GET_STR(dest);
	P_FINISH;

	((UHXGameEngine *)GetLevel()->Engine)->CopySaveGameFiles(source, dest);

	unguardexec;
}


// EngineGetSaveInfo()
IMPLEMENT_FUNCTION(AHXGameInfo,2311,execEngineGetSaveInfo);
void AHXGameInfo::execEngineGetSaveInfo(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineGetSaveInfo);

	P_GET_OBJECT(UPackage, saveInfoPackage);
	P_FINISH;

	*(UDeusExSaveInfo **)Result = ((UHXGameEngine *)GetLevel()->Engine)->GetSaveInfo(saveInfoPackage);

	unguardexec;
}


// EngineDeleteGame()
IMPLEMENT_FUNCTION(AHXGameInfo,2310,execEngineDeleteGame);
void AHXGameInfo::execEngineDeleteGame(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execEngineDeleteGame);

	P_GET_INT(Position);
	P_FINISH;

	((UHXGameEngine *)GetLevel()->Engine)->DeleteGame(Position);

	unguardexec;
}


// GetEngine()
IMPLEMENT_FUNCTION(AHXGameInfo,2300,execGetEngine);
void AHXGameInfo::execGetEngine(FFrame& Stack, RESULT_DECL)
{
	guard(AHXGameInfo::execGetEngine);

	P_FINISH;

	*(UEngine **)Result = GetLevel()->Engine;

	unguardexec;
}



/*------------------------------------------------------------------------------------
	The End.
------------------------------------------------------------------------------------*/
