//=============================================================================
// OrangeBumpMaps
//=============================================================================
class OrangeBumpMaps extends Mutator;

var Texture CreateBreakableMedBumpMap;


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor A, out byte bSuperRelevant)
{
	if (A.isA('CrateBreakableMedCombat')
		||A.isA('CrateBreakableMedCombat')
		||A.isA('CrateBreakableMedCombat'))
		AddBumpMap(A, CreateBreakableMedBumpMap);
	
	return true;
}

// ----------------------------------------------------------------------
// AddBumpMap()
// ----------------------------------------------------------------------

function AddBumpMap(Actor A, Texture T)
{
	A.Texture.BumpMap = T;
	Log("Added BumpMap Texture '" $ T.Class $ "' to '" $ A.Class $ "'");
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
