//=============================================================================
// HXATM.
//=============================================================================
class HXATM extends HXComputers;

// Userlist information.
struct sATMUserInfo
{
	var() string	accountNumber;
	var() string	PIN;
	var() int		balance;
};
var() sATMUserInfo ATMUserList[8];

var bool bSuckedDryByHack;

// ----------------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------------

replication
{
	// server to client
	reliable if ( Role==ROLE_Authority )
		ATMUserList, bSuckedDryByHack;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local ATM OtherATM;
	local int i;

	// Call Super.
	Super.Succeeds( Other );

	// Special ATM Init.
	OtherATM = ATM(Other);
	if ( OtherATM!=None )
	{
		for ( i=0; i<8; i++ )
		{
			ATMUserList[i].AccountNumber	= OtherATM.UserList[i].AccountNumber;
			ATMUserList[i].PIN						= OtherATM.UserList[i].PIN;
			ATMUserList[i].Balance				= OtherATM.UserList[i].Balance;
		}

		LockoutDelay = OtherATM.LockoutDelay;
	}
}

// ----------------------------------------------------------------------------
// NumUsers()
// ----------------------------------------------------------------------------

function int NumUsers()
{
	local int i;

	for (i=0; i<ArrayCount(ATMUserList); i++)
		if (ATMUserList[i].accountNumber == "")
			break;

	return i;
}

// ----------------------------------------------------------------------------
// GetBalance() -- JUST USE ON SERVER!
// ----------------------------------------------------------------------------

function int GetBalance( int UserIndex, float Mod )
{
	local int i, Sum;

	Sum = 0;

	if ( UserIndex>=0 && UserIndex<ArrayCount(UserList) )
	{
		Sum = ATMUserList[UserIndex].Balance;
	}
	else if ( UserIndex==-1 )
	{
		// If we've been hacked, sum all the accounts.
		for ( i=0; i<ArrayCount(UserList); i++ )
			Sum += ATMUserList[i].Balance;
		Sum *= Mod;
	}

	return Sum;
}

// ----------------------------------------------------------------------------
// ModBalance()
//
// UserIndex==-1 denotes hacking.
// ----------------------------------------------------------------------------

function ModBalance( int UserIndex, int NumCredits, bool bSync, float HackBalanceModifier )
{
	local HXATM OtherATM;
	local float ReducedBalance;
	local int i, j;

	// Logged in with account.
	if ( UserIndex>=0 && UserIndex<ArrayCount(ATMUserList) )
	{
		// Make sure we don't get negative.
		NumCredits = Min( NumCredits, ATMUserList[UserIndex].Balance );

		// Remove credits.
		ATMUserList[UserIndex].Balance -= NumCredits;

		// Sync the balance with all other ATMs on this map,
		if ( bSync )
			foreach AllActors( Class'HXATM', OtherATM )
				for ( i=0; i<OtherATM.NumUsers(); i++ )
					if ( OtherATM!=Self && Caps(ATMUserList[UserIndex].AccountNumber)==OtherATM.GetAccountNumber(i) && Caps(ATMUserList[UserIndex].PIN)==OtherATM.GetPIN(i) )
						OtherATM.ModBalance( i, NumCredits, False, HackBalanceModifier );
	}
	// Hacked.
	else if ( UserIndex==-1 )
	{
		// Sync the balance with all other ATMs on this map.
		if ( bSync )
			foreach AllActors( Class'HXATM', OtherATM )
				if ( OtherATM!=Self )
					for ( i=0; i<OtherATM.NumUsers(); i++ )
						for ( j=0; j<NumUsers(); j++ )
							if ( Caps(ATMUserList[j].AccountNumber)==OtherATM.GetAccountNumber(i) && Caps(ATMUserList[j].PIN)==OtherATM.GetPIN(i) )
							{
								ReducedBalance = ATMUserList[j].Balance*HackBalanceModifier+0.5; // Let the bank keep rounding errors.
								OtherATM.ModBalance( i, int(ReducedBalance), False, HackBalanceModifier );
							}

		// If we've been hacked, zero all the accounts if we have enough to transfer.
		for ( i=0; i<ArrayCount(ATMUserList); i++ )
			ATMUserList[i].Balance = 0;

		// Set bSuckedDryByHack here, so it happens on the server (and gets replicated to other clients).
		bSuckedDryByHack = True;
	}
}

// ----------------------------------------------------------------------------
// GetAccountNumber()
// ----------------------------------------------------------------------------

function string GetAccountNumber(int userIndex)
{
	if ((userIndex >= 0) && (userIndex < ArrayCount(ATMUserList)))
		return Caps(ATMUserList[userIndex].accountNumber);
	else if (userIndex == -1)
		return "HACKED";

	return "ERR";
}

// ----------------------------------------------------------------------------
// GetPIN()
// ----------------------------------------------------------------------------

function string GetPIN(int userIndex)
{
	if ((userIndex >= 0) && (userIndex < ArrayCount(ATMUserList)))
		return Caps(ATMUserList[userIndex].PIN);
	else if (userIndex == -1)
		return "HACKED";

	return "ERR";
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	TerminalType=HXNetworkTerminalATM
	bPlayActivationAnimations=False
	LockoutDelay=60.0
	MsgLockedOut="Terminal is locked out for %d more seconds"
	ItemName="Public Banking Terminal"
	Physics=PHYS_None
	Mesh=ATM
	SoundRadius=8
	SoundVolume=255
	AmbientSound=ElectronicsHum
	CollisionRadius=22.00
	//CollisionHeight=40.00
	CollisionHeight=39.25
	bCollideWorld=False
	Mass=400.0
	Buoyancy=200.0
}
