//=============================================================================
// HXAcousticSensor.
//=============================================================================
class HXAcousticSensor extends HXHackableDevices;

// ----------------------------------------------------------------------------
// HackAction().
// ----------------------------------------------------------------------------

function HackAction( Actor Hacker, bool bHacked )
{
	local Actor A;

	Super.HackAction( Hacker, bHacked );

	if ( bHacked )
	{
		AIClearEventCallback( 'WeaponFire' );
	}
}

// ----------------------------------------------------------------------------
// HandleShot().
//
// Params.BestActor is either a ScriptedPawn or the Player firing a shot.
// Depending on trigger setup, it might fail for AutoTurrets or when
// a player is actually needed as event instigator (but that should be
// accounted for inside the other classes).
// ----------------------------------------------------------------------------

function HandleShot( Name EventName, EAIEventState State, XAIParams Params )
{
	local Actor	Actor;

	//Log( "HandleShot: Params.BestActor=" $ Params.BestActor, 'AcousticSensor' );

	if ( Event!='' )
		foreach AllActors( Class 'Actor', Actor, Event )
			Actor.Trigger( Self, Pawn(Params.BestActor) );
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay().
// ----------------------------------------------------------------------------

simulated function PostPostBeginPlay()
{
	Super.PostPostBeginPlay();

	if ( Role==ROLE_Authority )
	{
		// Do this in PostPostBeginPlay() now, 
		// so it is done each time the map is (re)loaded and I can 
		// clear EventManager which hopefully solves remaining listen server
		// crash issue (was in PostBeginPlay() before).
		// Remark: Yes it solved it.
		if ( HackStrength~=0.0 ) // Hacked.
		{
			AIClearEventCallback( 'WeaponFire' );
		}
		else
		{
			AISetEventCallback( 'WeaponFire', 'HandleShot' );	
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Gunfire Acoustic Sensor"
	Mesh=AcousticSensor
	CollisionRadius=24.400
	//CollisionHeight=23.056
	CollisionHeight=22.306
	Mass=10.0
	Buoyancy=5.0
}
