//=============================================================================
// HXActor.
//=============================================================================
class HXActor extends Actor
	native;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

// Version info.
const HX_VERSION_STRING = "Version 0.9.89.4";

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
	reliable if( bDemoRecording )
		DemoStopSoundSlot, DemoStopAllSoundSlots;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Advanced.
//bStatic              = Other.bStatic;             // Nope. Defined by defaultproperties.
	bHidden              = Other.bHidden;
//bNoDelete            = Other.bNoDelete;           // Nope. Defined by defaultproperties.
	bCanTeleport         = Other.bCanTeleport;        // Do I want this?
	bIsSecretGoal        = Other.bIsSecretGoal;
	bIsKillGoal          = Other.bIsKillGoal;
	bIsItemGoal          = Other.bIsItemGoal;
	bCollideWhenPlacing  = Other.bCollideWhenPlacing; // Still used by FarMove.
//bTravel              = Other.bTravel;             // Do not mess with this.
//bMovable             = Other.bMovable;            // Do not mess with this.
//bHighDetail          = Other.bHighDetail;         // Nah, do not mess with this.
//bStasis              = Other.bStasis;             // Rather not-ish.
//bForceStasis         = Other.bForceStasis;        // Rather not-ish.
//NetTemporary         = Other.NetTemporary;        // Certainly not.
//bNetOptional         = Other.bNetOptional;        // Certainly not.
  bBlockSight          = Other.bBlockSight;
  bDetectable          = Other.bDetectable;
//bTransient           = Other.bTransient;          // Rather not-ish.
	LifeSpan             = Other.LifeSpan;
	bHiddenEd            = Other.bHiddenEd;           // Editing flag.
	bDirectional         = Other.bDirectional;        // Editing flag.
	bEdShouldSnap        = Other.bEdShouldSnap;       // Editing flag.
//bOwnerNoSee          = Other.bOwnerNoSee;         // Rather not-ish.
//bOnlyOwnerSee        = Other.bOnlyOwnerSee;       // Rather not-ish.
//bAlwaysRelevant      = Other.bAlwaysRelevant;     // Certainly not-ish.
//bGameRelevant        = Other.bGameRelevant;       // Rather uncertain-ish.
	bOwned               = Other.bOwned;

	// Collision.
	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );
	//bCollideWorld	       = Other.bCollideWorld;       // !! This can be an issue to copy. Inventory falls through the floor, etc. !!
	bProjTarget          = Other.bProjTarget;

	// Conversation.
	BindName             = Other.BindName;            // !! Shadowed for ConversationTrigger.
	BarkBindName         = Other.BarkBindName;
	FamiliarName         = Other.FamiliarName;
	UnfamiliarName       = Other.UnfamiliarName;
	ConStartInterval     = Other.ConStartInterval;

	// Display.
	DrawType             = Other.DrawType;
	Style                = Other.Style;
	Sprite               = Other.Sprite;
	Texture              = Other.Texture;
	Skin                 = Other.Skin;
	MultiSkins[0]        = Other.MultiSkins[0];
	MultiSkins[1]        = Other.MultiSkins[1];
	MultiSkins[2]        = Other.MultiSkins[2];
	MultiSkins[3]        = Other.MultiSkins[3];
	MultiSkins[4]        = Other.MultiSkins[4];
	MultiSkins[5]        = Other.MultiSkins[5];
	MultiSkins[6]        = Other.MultiSkins[6];
	MultiSkins[7]        = Other.MultiSkins[7];
	Mesh                 = Other.Mesh;
	DrawScale            = Other.DrawScale;
	ScaleGlow            = Other.ScaleGlow;
	AmbientGlow          = Other.AmbientGlow;
	Fatness              = Other.Fatness;
	bUnlit               = Other.bUnlit;
//bNoSmooth            = Other.bNoSmooth;           // Not replicated.
//bParticles           = Other.bParticles;          // Not replicated.
//bRandomFrame         = Other.bRandomFrame;        // Not replicated.
	bMeshEnviroMap       = Other.bMeshEnviroMap;
//bMeshCurvy           = Other.bMeshCurvy;          // Not replicated.
//VisibilityRadius     = Other.VisibilityRadius;    // Not replicated.
//VisibilityHeight     = Other.VisibilityHeight;    // Not replicated.
//bShadowCast          = Other.bShadowCast;         // Not replicated.
	AnimSequence         = Other.AnimSequence;        // Preset?
	AnimFrame            = Other.AnimFrame;           // Preset? Implicit replicated?
	AnimRate             = Other.AnimRate;            // Preset? Implicit replicated?
//LODBias              = Other.LODBias;             // Not replicated.
//RenderIteratorClass  = Other.RenderIteratorClass; // Not replicated.

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Filter.
	bDifficulty0         = Other.bDifficulty0;
	bDifficulty1         = Other.bDifficulty1;
	bDifficulty2         = Other.bDifficulty2;
	bDifficulty3         = Other.bDifficulty3;
	bSinglePlayer        = Other.bSinglePlayer;
	bNet                 = Other.bNet;
	bNetSpecial          = Other.bNetSpecial;
	OddsOfAppearing      = Other.OddsOfAppearing;

	// LightColor.
	LightBrightness      = Other.LightBrightness;
	LightHue             = Other.LightHue;
	LightSaturation      = Other.LightSaturation;

	// Lighting.
	LightType            = Other.LightType;
	LightEffect          = Other.LightEffect;
	LightRadius          = Other.LightRadius;
	LightPeriod          = Other.LightPeriod;
	LightPhase           = Other.LightPhase;
//LightCone            = Other.LightCone;        // Not replicated.
	VolumeBrightness     = Other.VolumeBrightness;
	VolumeRadius         = Other.VolumeRadius;
//VolumeFog            = Other.VolumeFog;        // Not replicated.
	bSpecialLit          = Other.bSpecialLit;
//bActorShadows        = Other.bActorShadows;    // Not replicated.
	bCorona              = Other.bCorona;          // Not replicated.
	bLensFlare           = Other.bLensFlare;       // Not replicated.

	// Movement.
//Location            = Other.Location; // Set by Spawn.
//Rotation            = Other.Rotation; // Set by Spawn.
//Velocity            = Other.Velocity; // Nah.
//SetPhysics( Other.Physics );          // Tricky-ish. I'm now using SpawnPhysics though.
	AttachTag           = Other.AttachTag;
	bBounce             = Other.bBounce;
	bFixedRotationDir   = Other.bFixedRotationDir;
	bRotateToDesired    = Other.bRotateToDesired;
	Mass                = Other.Mass;
	Buoyancy            = Other.Buoyancy;
	RotationRate        = Other.RotationRate;
	DesiredRotation     = Other.DesiredRotation;

	// Networking.
//RemoteRole           = Other.RemoteRole;         // I certainly
//NetPriority          = Other.NetPriority;        // won't use
//NetUpdateFrequency   = Other.NetUpdateFrequency; // these
//RelevantRadius       = Other.RelevantRadius;     // values. --han

	// Object.
	InitialState         = Other.InitialState; // Does this even work out of the box?
	Group                = Other.Group;

	// Smell.
	SmellClass           = Other.SmellClass;

	// Sound.
	SoundRadius          = Other.SoundRadius;
	SoundVolume          = Other.SoundVolume;
	SoundPitch           = Other.SoundPitch;
	AmbientSound         = Other.AmbientSound;
//TransientSoundVolume = Other.TransientSoundVolume; // Not replicated.
//TransientSoundRadius = Other.TransientSoundRadius; // Not replicated.

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
	Other.BindName       = "";
	Other.BarkBindName   = "";

	// Remove Collision of old Actor if bStatic or bNoDelete.
	if ( Other.bStatic || Other.bNoDelete )
	{
		Other.SetCollision( false, false, false );
	}
}

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( PrecessorName!='' )
	{
		Log( Sprintf("Precessor of falling out of world %s was %s.",Name,PrecessorName), 'FellOutOfWorld' );
	}

	SetPhysics( PHYS_None );
	Destroy();
}	

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient );

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// GENERAL PURPOSE FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//
// Spawn an actor. Returns an actor of class Actor and not of the 
// specified class unlike Spawn() (this was hardcoded in the compiler).
// if the actor could not be spawned (either the actor wouldn't fit in
// the specified location, or the actor list is full).
// Defaults to spawning at the spawner's location.
// Works in the same way as Spawn() did, but has the additional
// parameter bSpawnNoCollisionFail which exposes the bNoCollisionFail
// parameter of ULevel::SpawnActor().
//
native(3200) final function Actor SpawnEx
(
	class<Actor>      SpawnClass,
	optional Actor	  SpawnOwner,
	optional Name     SpawnTag,
	optional Vector   SpawnLocation,
	optional Rotator  SpawnRotation,
	optional bool			bSpawnNoCollisionFail,
	optional EPhysics SpawnPhysics
);

//
// Complements for RadiusActors to support other simple
// geometric shapes. All distances messured from center to maximum.
// (e.g. dZ is half the height in case of a cylinder).
//
/*
native(3210) final iterator function BallActors( Class<Actor> BaseClass, out actor Actor, float Radius, optional Vector Origin ); // Slightly adjusted version of RadiusActors.
native(3211) final iterator function CubeActors( Class<Actor> BaseClass, out actor Actor, float dL, optional Vector Origin );
native(3212) final iterator function CuboidActors( Class<Actor> BaseClass, out actor Actor, float dX, float dY, float dZ, optional Vector Origin );
native(3213) final iterator function CylinderActors( Class<Actor> BaseClass, out actor Actor, optional float Radius, optional float dZ, optional Vector Origin ); // Defaults to Actors collision cylinder.
native(3214) final iterator function CylindroidActors( Class<Actor> BaseClass, out actor Actor, Vector FirstFocal, Vector SecondFocal, float dZ ); // FirstFocal.z and SecondFocal.z is ignored.
native(3215) final iterator function RotationalEllipsoidActors( Class<Actor> BaseClass, out actor Actor, Vector FirstFocal, Vector SecondFocal );
*/
//
// Static version of above function which use Other instead of Self which is supplied by first parameter.
//
/* 
native(3220) final static iterator function StaticCubeActors( Actor Other, Class<Actor> BaseClass, out actor Actor, float dL, optional Vector Location );
native(3221) final static iterator function StaticCuboidActors( Actor Other, Class<Actor> BaseClass, out actor Actor, float dX, float dY, float dZ, optional Vector Location );
native(3222) final static iterator function StaticCylinderActors( Actor Other, Class<Actor> BaseClass, out actor Actor, optional float Radius, optional float dZ, optional Vector Location ); // Defaults to Others collision cylinder.
native(3223) final static iterator function StaticCylindroidActors( Actor Other, Class<Actor> BaseClass, out actor Actor, float dX, float dY, float dZ, optional Vector Location );
native(3224) final static iterator function StaticEllipsoidActors( Actor Other, Class<Actor> BaseClass, out actor Actor, float dX, float dY, float dZ, optional Vector Location );
*/

// Creates random normalized 2D Vector.
static final function Vector VRand2D()
{
	local Rotator RandRot;
	RandRot.Yaw = FRand() * 65535.0;
	return Vector(RandRot);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// TRACING FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//
// Fixed and extended version of TraceTexture() which also returns
// the Texture hit (Hint: There are Sound properties on Texture).
//
native(3250) final iterator function TraceTextures
(
	Class<Actor> BaseClass,
	out Actor    HitActor,
	out Texture  Texture,
	out Name     TextureName,
	out Name     TextureGroup,
	out int      TextureFlags,
	out Vector   HitLocation,
	out Vector   HitNormal,
	Vector       TraceEnd,
	optional Vector TraceStart,
	optional Vector TraceExtent
);

//
// First Hit variant of TraceTextures.
// (The same as Trace is to TraceActors)
//
native(3251) final function Actor TraceSingleTexture
(
	Class<Actor> BaseClass,
	out Texture  Texture,
	out Name     TextureName,
	out Name     TextureGroup,
	out int      TextureFlags,
	out Vector   HitLocation,
	out Vector   HitNormal,
	Vector       TraceEnd,
	optional Vector TraceStart,
	optional bool bTraceActors,
	optional Vector TraceExtent
);

//
// Static versions of above function which use Other instead
// of Self which is supplied by first parameter.
//
native(3252) final static iterator function StaticTraceTextures
(
	Actor Other,
	Class<Actor> BaseClass,
	out Actor    HitActor,
	out Texture  Texture,
	out Name     TextureName,
	out Name     TextureGroup,
	out int      TextureFlags,
	out Vector   HitLocation,
	out Vector   HitNormal,
	Vector       TraceEnd,
	optional Vector TraceStart,
	optional Vector TraceExtent
);
native(3253) final static function Actor StaticTraceSingleTexture
(
	Actor Other,
	Class<Actor> BaseClass,
	out Texture  Texture,
	out Name     TextureName,
	out Name     TextureGroup,
	out int      TextureFlags,
	out Vector   HitLocation,
	out Vector   HitNormal,
	Vector       TraceEnd,
	optional Vector TraceStart,
	optional bool bTraceActors,
	optional Vector TraceExtent
);

//
// Returns true if did not hit non transparent world geometry.
// This might not be exact as this might check a coplanar bsp surface.
// However most windows are on a different plane, so this works
// fine nearly all the time (expect for maybe ugly maps) so it would
// not be worth the additional performance hit.
//
// Code by Smirftsch/Dots kindly donated by Smirftsch.
//
native(3254) final function bool FastRepTrace
(
	vector          TraceEnd,
	optional Vector TraceStart
);

//
// Behaves the same FastTrace but returns the
// surface texture if a hit occured.
//
/*native(3255) final function bool FastTextureTrace
(
	Vector          TraceEnd,
	out Texture     Texture,
	out Name        TextureName,
	out Name        TextureGroup,
	out int         TextureFlags,
	optional Vector TraceStart
);*/

//
// Static versions of above functions. Takes
// the  Level to use as the first parameter.
// 
native(3256) final static function bool StaticFastRepTrace
(
	LevelInfo LevelInfo,
	vector    TraceEnd,
	Vector    TraceStart
);
/*native(3257) final static function bool StaticFastTextureTrace
(
	LevelInfo   LevelInfo,
	Vector      TraceEnd,
	out Texture Texture,
	out Name    TextureName,
	out Name    TextureGroup,
	out int     TextureFlags,
	Vector      TraceStart
);*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// STRING FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// String to Name conversion.
native(3260) final static function name StringToName( coerce string S );

// Case insensitve string hashing.
native(3261) final static function int Strihash( coerce string S );

// Matches Extension.Window() which actually just returns a line feed.
static final function String CarriageReturn()
{
	return Chr(10);
}

// Short form of CarriageReturn(). Thats LF though.
static final function String CR()
{
	return Chr(10);
}

//
// Text replacment. Copied out of UWindowWindow.
//
final static function ReplaceText( out string Text, string Replace, string With )
{
	local int i;
	local string Input;
		
	Input = Text;
	Text = "";
	i = InStr( Input, Replace );
	while ( i!=-1 )
	{	
		Text = Text $ Left(Input,i) $ With;
		Input = Mid( Input, i+Len(Replace) );
		i = InStr( Input, Replace );
	}
	Text = Text $ Input;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// CONVERSATION FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

native(3270) final static function bool BindConversationList( String ConvListClass, Actor Target );

//
// Replacement for Conversation.BindEvents, which could potentially bind to actors outside of map
// and potentially bounds twice to PlayerPawns.
//
// Should this bind GameInfo as well?
//
native(3271) final static function BindConsersationEvents( Conversation Con, Actor ConBoundActors[10], Actor InvokeActor, Level Scope );

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// SOUND FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//
// Stops the specified or all sound slots for an Actor. These functions are network transparent,
// but unlike PlaySound() use a reliable network replication pattern and do no distance checks.
// They share the same behaviour regarding simulated functions and invokation on network clients
// as PlaySound() does. This includes that you need to run those inside a simulated function when 
// PlaySound() for that slot was called inside a simulated function (note that the server can invoke
// playback of a sound inside the same slot as the client for an given actor and they will both be 
// played at the same time, so sound slots are not mutually exclusive in this situation!).
// To avoid problems in netplay you should ensure that there is a slight amount of time
// between PlaySound() and StopSoundSlot()/StopAllSoundSlots() call, so both will likely be
// execute in order on the network client (note that the same argument applies to multiple
// PlaySound() calls for the same channel, so this is no new issue introduce by these functions).
//
native(3281) final function StopSoundSlot( ESoundSlot Slot );
native(3282) final function StopAllSoundSlots();

// Internal.
native simulated event DemoStopSoundSlot( ESoundSlot Slot );
native simulated event DemoStopAllSoundSlots();

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// RANDOM FUNCTIONS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// VDiskRand2D()
//
// Random point on Disk in xy-plane.
// http://mathworld.wolfram.com/DiskPointPicking.html
//
// Could be optimized.
// ----------------------------------------------------------------------------

simulated final static function Vector VDiskRand2D( float DiskRadius )
{
	local float  Radius, Angle;
	local Vector Point;

	Radius = Sqrt(FRand())*DiskRadius;
	Angle  = FRand()*2.0*PI;

	Point.X = Radius*Cos(Angle);
	Point.Y = Radius*Sin(Angle);

	return Point;
}

// ----------------------------------------------------------------------------
// TPDFShape()
//
// Generates triangular-distributed random variates out of uniform distributed
// random variates in the interval [0,1].
//
// https://en.wikipedia.org/wiki/Triangular_distribution
// #Generating_triangular-distributed_random_variates
// ----------------------------------------------------------------------------

simulated final static function float TPDFShape( float Random, float Left, float Mid, float Right )
{
	local float F;

	F = (Mid-Left)/(Right-Left);
	if ( Random<F )
		return Left+Sqrt(Random*(Right-Left)*(Mid-Left));
	else
		return Right-Sqrt((1.0-Random)*(Right-Left)*(Right-Mid));
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// MISC
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//
// Helper to exchange the value of two floating point numbers.
// UnrealScript intepretations of the useful Exchange template.
//
static final function ExchangeByte( out byte A, out byte B )
{
	local byte T; T = A; A = B; B = T;
}
static final function ExchangeInt( out int A, out int B )
{
	local int T; T = A; A = B; B = T;
}
static final function ExchangeFloat( out float A, out float B )
{
	local float T; T = A; A = B; B = T;
}
static final function ExchangeString( out string A, out string B )
{
	local string T; T = A; A = B; B = T;
}
static final function ExchangeName( out name A, out name B )
{
	local name T; T = A; A = B; B = T;
}
// ExchangeVector?
// ExchangeRotator?

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// VERSION INFO
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

static function String GetVersionString()
{
	return HX_VERSION_STRING;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
	bMovable=True
	bDetectable=True
	Role=ROLE_Authority
	RemoteRole=ROLE_DumbProxy
	LastRenderTime=-10.0
	LODBias=1.0
	bDifficulty0=True
	bDifficulty1=True
	bDifficulty2=True
	bDifficulty3=True
	bSinglePlayer=True
	bNet=True
	bNetSpecial=True
	OddsOfAppearing=1.0
	DrawType=DT_Sprite
	Style=STY_Normal
	Texture=S_Actor
	DrawScale=1.0
	ScaleGlow=1.0
	Fatness=128
	SoundRadius=32
	SoundVolume=128
	SoundPitch=64
	TransientSoundVolume=1.0
	CollisionRadius=22.0
	CollisionHeight=22.0
	bJustTeleported=True
	Mass=100.0
	ConStartInterval=5.0
	NetPriority=1.0
	NetUpdateFrequency=100.0
}
