//=============================================================================
// HXAlarmLight.
//=============================================================================
class HXAlarmLight extends HXDecoration;

enum ESkinColor
{
	SC_Red,
	SC_Green,
	SC_Blue,
	SC_Amber
};

var() ESkinColor SkinColor;
var() bool bIsOn;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local AlarmLight OtherAlarmLight;

	// Call Super.
	Super.Succeeds( Other );

	// Special AlarmLight Init.
	OtherAlarmLight = AlarmLight(Other);
	if ( OtherAlarmLight!=None )
	{
		SetPropertyText("SkinColor", OtherAlarmLight.GetPropertyText("SkinColor") );
		bIsOn = OtherAlarmLight.bIsOn;
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		SetLightColor( SkinColor );

		if ( !bIsOn )
		{
			MultiSkins[1] = Texture'BlackMaskTex';
			LightType = LT_None;
			bFixedRotationDir = False;
		}
	}
}

function SetLightColor(ESkinColor color)
{
	switch (SkinColor)
	{
		case SC_Red:		MultiSkins[1] = Texture'AlarmLightTex2';
							MultiSkins[2] = Texture'AlarmLightTex3';
							Texture = Texture'AlarmLightTex3';
							LightHue = 0;
							break;
		case SC_Green:		MultiSkins[1] = Texture'AlarmLightTex4';
							MultiSkins[2] = Texture'AlarmLightTex5';
							Texture = Texture'AlarmLightTex5';
							LightHue = 64;
							break;
		case SC_Blue:		MultiSkins[1] = Texture'AlarmLightTex6';
							MultiSkins[2] = Texture'AlarmLightTex7';
							Texture = Texture'AlarmLightTex7';
							LightHue = 160;
							break;
		case SC_Amber:		MultiSkins[1] = Texture'AlarmLightTex8';
							MultiSkins[2] = Texture'AlarmLightTex9';
							Texture = Texture'AlarmLightTex9';
							LightHue = 36;
							break;
	}
}

// if we are triggered, turn us on
function Trigger(Actor Other, Pawn Instigator)
{
	if (!bIsOn)
	{
		bIsOn = True;
		SetLightColor(SkinColor);
		LightType = LT_Steady;
		bFixedRotationDir = True;
	}

	Super.Trigger(Other, Instigator);
}

// if we are untriggered, turn us off
function UnTrigger(Actor Other, Pawn Instigator)
{
	if (bIsOn)
	{
		bIsOn = False;
		MultiSkins[1] = Texture'BlackMaskTex';
		LightType = LT_None;
		bFixedRotationDir = False;
	}

	Super.UnTrigger(Other, Instigator);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bIsOn=True
	FragType=PlasticFragment
	ItemName="Alarm Light"
	bPushable=False
	Physics=PHYS_Rotating
	Texture=AlarmLightTex3
	Mesh=AlarmLight
	MultiSkins(1)=BlackMaskTex
	MultiSkins(2)=AlarmLightTex3
	CollisionRadius=4.00
	//CollisionHeight=6.14
	CollisionHeight=5.39
	LightType=LT_Steady
	LightEffect=LE_Spotlight
	LightBrightness=255
	LightRadius=32
	LightCone=32
	bFixedRotationDir=True
	Mass=20.0
	Buoyancy=15.0
	RotationRate=(Yaw=98304)
}
