//=============================================================================
// HXAlignButtonWindow - Bascially just a copy of AlignWindow but with 
//                       ButtonWindow as parent.
//=============================================================================
class HXAlignButtonWindow extends ButtonWindow;

var float   ChildSpacing;
var EVAlign ChildVAlign;

// ----------------------------------------------------------------------
// ComputeChildSizes()
// ----------------------------------------------------------------------

function ComputeChildSizes( bool bWidthSpecified, out float PreferredWidth, bool bHeightSpecified, out float PreferredHeight )
{
	local float  TotalWidth;
	local float  MaxHeight;
	local Window Child;
	local Window NextChild;

	TotalWidth = 0;
	MaxHeight  = 0;

	Child = GetBottomChild();
	while ( Child!=None )
	{
		NextChild = Child.GetHigherSibling();

		Child.HoldX = TotalWidth;
		Child.HoldY = 0;
		if ( NextChild==None )  // last child
		{
			if ( bWidthSpecified )
			{
				Child.HoldWidth  = PreferredWidth - TotalWidth;
				Child.HoldHeight = Child.QueryPreferredHeight( Child.HoldWidth );
			}
			else
				Child.QueryPreferredSize( Child.HoldWidth, Child.HoldHeight );
		}
		else
		{
			Child.QueryPreferredSize( Child.HoldWidth, Child.HoldHeight );
			TotalWidth += ChildSpacing;
		}

		TotalWidth += Child.HoldWidth;
		if ( MaxHeight<Child.HoldHeight )
			MaxHeight = Child.HoldHeight;

		Child = NextChild;
	}

	if ( bHeightSpecified )
		MaxHeight = PreferredHeight;

	Child = GetBottomChild();
	while ( Child!=None )
	{
		if      ( ChildVAlign == VALIGN_Top)
			Child.HoldY = 0;
		else if ( ChildVAlign == VALIGN_Center)
			Child.HoldY = (MaxHeight - Child.HoldHeight)/2.0;
		else if ( ChildVAlign == VALIGN_Bottom)
			Child.HoldY = MaxHeight - Child.HoldHeight;
		else if ( ChildVAlign == VALIGN_Full)
		{
			Child.HoldY      = 0;
			Child.HoldHeight = MaxHeight;
		}

		Child = Child.GetHigherSibling();
	}

	if ( !bWidthSpecified )
		PreferredWidth  = TotalWidth;
	if ( !bHeightSpecified )
		PreferredHeight = MaxHeight;
}

// ----------------------------------------------------------------------
// ParentRequestedPreferredSize()
// ----------------------------------------------------------------------

event ParentRequestedPreferredSize( bool bWidthSpecified, out float PreferredWidth, bool bHeightSpecified, out float PreferredHeight )
{
	ComputeChildSizes( bWidthSpecified, PreferredWidth, bHeightSpecified, PreferredHeight );
}

// ----------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------

function ConfigurationChanged()
{
	local float  TempWidth, TempHeight;
	local Window Child;

	// just for safety
	TempWidth  = Width;
	TempHeight = Height;
	ComputeChildSizes( True, TempWidth, True, TempHeight );

	child = GetBottomChild();
	while ( Child!=None )
	{
		Child.ConfigureChild( Child.HoldX, Child.HoldY, Child.HoldWidth, Child.HoldHeight );
		Child = Child.GetHigherSibling();
	}
}

// ----------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------

event bool ChildRequestedReconfiguration( Window ChildWin )
{
	return False;
}

// ----------------------------------------------------------------------
// SetChildSpacing()
// ----------------------------------------------------------------------

function SetChildSpacing( float NewChildSpacing )
{
	if ( ChildSpacing!=NewChildSpacing )
	{
		ChildSpacing = NewChildSpacing;
		AskParentForReconfigure();
	}
}

// ----------------------------------------------------------------------
// SetChildVAlignment()
// ----------------------------------------------------------------------

function SetChildVAlignment( EVAlign newChildVAlign )
{
	if ( ChildVAlign!=NewChildVAlign )
	{
		ChildVAlign = NewChildVAlign;
		AskParentForReconfigure();
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
