//=============================================================================
// HXAllianceTrigger.
//
// Set an NPCs alliances.
//=============================================================================
class HXAllianceTrigger extends HXTrigger;

struct InitialAllianceInfo
{
	var() Name  AllianceName;
	var() float AllianceLevel;
	var() bool  bPermanent;
};

var() Name Alliance;
var() InitialAllianceInfo Alliances[8];

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local AllianceTrigger OtherAllianceTrigger;
	local int iAlliance;

	// Call Super.
	Super.Succeeds( Other );

	// Special AllianceTrigger Init.
	OtherAllianceTrigger = AllianceTrigger(Other);
	if ( OtherAllianceTrigger!=None )
	{
		// AllianceTrigger.
		Alliance = OtherAllianceTrigger.Alliance;

		for ( iAlliance=0; iAlliance<ArrayCount(Alliances); iAlliance++ )
		{
			Alliances[iAlliance].AllianceName  = OtherAllianceTrigger.Alliances[iAlliance].AllianceName;
			Alliances[iAlliance].AllianceLevel = OtherAllianceTrigger.Alliances[iAlliance].AllianceLevel;
			Alliances[iAlliance].bPermanent    = OtherAllianceTrigger.Alliances[iAlliance].bPermanent;
		}
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	SetAlliances();

	Super.Trigger( Other, Instigator );

	if ( bTriggerOnceOnly )
		Destroy();
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch( Actor Other )
{
	if ( !IsRelevant(Other) )
		return;

	SetAlliances();

	if ( bTriggerOnceOnly )
		Destroy();
}

// ----------------------------------------------------------------------------
// SetAlliances()
// ----------------------------------------------------------------------------

function SetAlliances()
{
	local HXScriptedPawn ScriptedPawn;
	local Pawn Pawn;
	local int iAlliance;

	if ( Event=='' )
		return;

	// Find the target NPC to set alliances.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		// Does not need to check the Event=='' case to match AllActors interator, as this case was ruled out above.
		if ( Pawn.Tag!=Event )
			continue;

		ScriptedPawn = HXScriptedPawn(Pawn);
		if ( ScriptedPawn==None )
			continue;

		ScriptedPawn.SetAlliance(Alliance);
		for ( iAlliance=0; iAlliance<ArrayCount(Alliances); iAlliance++ )
			if ( Alliances[iAlliance].AllianceName!='' )
				ScriptedPawn.ChangeAlly( Alliances[iAlliance].AllianceName, Alliances[iAlliance].AllianceLevel, Alliances[iAlliance].bPermanent );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=True
	CollisionRadius=96.0
}
