//=============================================================================
// HXAmmo.
//=============================================================================
class HXAmmo extends DeusExAmmo
	abstract;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

var const bool bCanDrop; // Whether we can be DropItem'ed.

var const localized string MsgDropNotAllowed;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Ammo OtherAmmo;

	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Advanced (partial).
	bHidden              = Other.bHidden;
	bOwned               = Other.bOwned;

	// Collision and Blocking.
	bCollideWhenPlacing = Other.bCollideWhenPlacing; // Still used for far moving after spawn.
	bCollideWorld       = true; //Other.bCollideWorld;

	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Object (partial).
	Group                = Other.Group;

	// Filter.
	bDifficulty0         = Other.bDifficulty0;
	bDifficulty1         = Other.bDifficulty1;
	bDifficulty2         = Other.bDifficulty2;
	bDifficulty3         = Other.bDifficulty3;
	bSinglePlayer        = Other.bSinglePlayer;

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
	Other.BindName       = "";
	Other.BarkBindName   = "";

	// Special Ammo Init.
	OtherAmmo = Ammo(Other);
	if ( OtherAmmo!=None )
	{
		// Ammo.
		AmmoAmount = OtherAmmo.AmmoAmount;
	}
}

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}
}

// -----------------------------------------------------------------------------
// PostBeginPlay()
// -----------------------------------------------------------------------------

function PostBeginPlay()
{
	// Get rid of mp ammo count.
	Super(Ammo).PostBeginPlay();
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);

	Super(Ammo).PostPostBeginPlay();
}

// ----------------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( PrecessorName!='' )
	{
		Log( Sprintf("Precessor of falling out of world %s was %s.",Name,PrecessorName), 'FellOutOfWorld' );
	}

	SetPhysics( PHYS_None );
	Destroy();
}	

//
// Give this inventory item to a pawn.
//
function GiveTo( pawn Other )
{
	// HX_INV
	SetOwner(Other);

	Instigator = Other;
	BecomeItem();
	Other.AddInventory( Self );
	GotoState('Idle2');
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	if ( parentammo != None )
	{
		Copy = spawn(parentammo,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;
		Copy.Instigator    = Other;
		Ammo(Copy).AmmoAmount = AmmoAmount;
		Copy.BecomeItem();
		Other.AddInventory( Copy );
		Copy.GotoState('');

		if ( Level.Game.ShouldRespawn(self) )
		{
			GotoState('Sleeping');

			//Destroy();
		}
		//else
			//Destroy();
	}
	else if( Level.Game.ShouldRespawn(self) )
	{
		Copy = spawn(Class,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;

		Ammo(Copy).AmmoAmount = AmmoAmount;

		GotoState('Sleeping');
		Destroy();
	}
	else
		Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.GiveTo( Other );

	return Copy;
}

// ----------------------------------------------------------------------------
// PlayLandingSound()
// ----------------------------------------------------------------------------

function PlayLandingSound()
{
	if (LandSound != None)
	{
		if (Velocity.Z <= -200)
		{
			PlaySound(LandSound, SLOT_None, TransientSoundVolume,, 768);
			AISendEvent('LoudNoise', EAITYPE_Audio, TransientSoundVolume, 768);
		}
	}
}

//=============================================================================
// state Pickup.
//
// This inventory item is sitting on the ground.
//=============================================================================

auto state Pickup
{
	function BeginState()
	{
		BecomePickup();
		bCollideWorld = true;

		//if ( Level.bStartup )
			//bAlwaysRelevant = true;

		// NumCopies = 1 means we have ONE of this item now DEUS_EX AJY
		//NumCopies = 0;
	}

	function EndState()
	{
		bCollideWorld = false;
		bSleepTouch = false;
	}

	singular function ZoneChange( ZoneInfo NewZone )
	{
		local float splashsize;
		local actor splash;

		if( NewZone.bWaterZone && !Region.Zone.bWaterZone ) 
		{
			splashSize = 0.000025 * Mass * (250 - 0.5 * Velocity.Z);
			if ( NewZone.EntrySound != None )
				PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
			if ( NewZone.EntryActor != None )
			{
				splash = Spawn(NewZone.EntryActor); 
				if ( splash != None )
					splash.DrawScale = 2 * splashSize;
			}
		}
	}

	// Validate touch, and if valid trigger event.
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && Pawn(Other).bIsPlayer && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					// Changed to using Self instead of Other, to be able to use this items Tag in triggered MissionScripts.
					//A.Trigger( Other, Other.Instigator );
					A.Trigger( Self, Pawn(Other) );

			return true;
		}
		return false;
	}

	// changed from Touch to Frob - DEUS_EX CNN
	function Frob(Actor Other, Inventory frobWith)
//	function Touch( actor Other )
	{
		local Inventory Copy;
		if ( ValidTouch(Other) ) 
		{
			Copy = SpawnCopy(Pawn(Other));
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
//			if (bActivatable && Pawn(Other).SelectedItem==None) 
//				Pawn(Other).SelectedItem=Copy;
			if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) Copy.Activate();
			if ( PickupMessageClass == None )
				// DEUS_EX CNN - use the itemArticle and itemName
//				Pawn(Other).ClientMessage(PickupMessage, 'Pickup');
				Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
			else
				Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
			PlaySound (PickupSound,,2.0);	
			Pickup(Copy).PickupFunction(Pawn(Other));
		}
	}

	// Landed on ground.
	function Landed(Vector HitNormal)
	{
		local rotator newRot;
		newRot = Rotation;
		newRot.pitch = 0;
		SetRotation(newRot);
		PlayLandingSound();  // DEUS_EX STM - added
//		SetTimer(2.0, false);	// DEUS_EX CNN - removed
	}

	// Make sure no pawn already touching (while touch was disabled in sleep).
	function CheckTouching()
	{
		local int i;

		bSleepTouch = false;
		for ( i=0; i<4; i++ )
			if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
				Touch(Touching[i]);
	}

Begin:
	BecomePickup();
	if ( bRotatingPickup && (Physics != PHYS_Falling) )
		SetPhysics(PHYS_Rotating);

Dropped:
	if( bAmbientGlow )
		AmbientGlow=255;
	if( bSleepTouch )
		CheckTouching();
}

// ----------------------------------------------------------------------------
// CanBeDropped()
//
// Called by HXPlayerPawn.DropItem() to see if we cannot be dropped for some
// reason.
// ----------------------------------------------------------------------------

function bool CanBeDropped( optional bool bSilent )
{
	// Handle this later over DropItem, not DropAmmo.
	if ( !bSilent )
		Pawn(Owner).ClientMessage( "Cannot drop Ammo over DropItem.", 'StatusLine' );
	return false;
}

// ----------------------------------------------------------------------------
// InfoTitle() and InfoText()
//
// Text only title and description intended for the info window.
// ----------------------------------------------------------------------------

simulated function string InfoTitle()
{
	return ItemName;
}

simulated function string InfoText()
{
	return Description;
}

// ----------------------------------------------------------------------------
// InventoryCapsString()
//
// Declared in Inventory. Used as a wrapper for retrieving the text for the
// Info window.
// ----------------------------------------------------------------------------

simulated function string InventoryCapsString( Name Property, Pawn Other, Actor Test )
{
	switch ( Property )
	{
		case 'InfoTitle':
			return InfoTitle();
			break;

		case 'InfoText':
			return InfoText();
			break;

		default:
			return "";
			break;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
	bDisplayableInv=False
	PickupMessage="You found"
	ItemName="DEFAULT AMMO NAME - REPORT THIS AS A BUG"
	ItemArticle=""
	PickupMessageClass=None
	RespawnTime=3153600000.0
	bCanDrop=False
	MsgDropNotAllowed="You are not allowed to drop your %s"
}
