//=============================================================================
// HXAmmo3006.
//=============================================================================
class HXAmmo3006 extends HXDeusExAmmo;

#exec MESH IMPORT MESH=HXAmmo3006Mesh ANIVFILE=Models\HXAmmo3006Mesh_a.3d DATAFILE=Models\HXAmmo3006Mesh_d.3d ZEROTEX=1
#exec MESHMAP SCALE MESHMAP=HXAmmo3006Mesh X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=HXAmmo3006Mesh SEQ=All	STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=HXAmmo3006Mesh SEQ=Still	STARTFRAME=0	NUMFRAMES=1

#exec MESHMAP SETTEXTURE MESHMAP=HXAmmo3006Mesh NUM=0 TEXTURE=Ammo3006Tex

// ----------------------------------------------------------------------------
// UseAmmo()
// ----------------------------------------------------------------------------

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((HXGameInfo(Level.Game) != None) && (!HXGameInfo(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bShowInfo=True
	AmmoAmount=6
	MaxAmmo=96
	ItemName="30.06 Ammo"
	ItemArticle="some"
	PickupViewMesh=HXAmmo3006Mesh
	Icon=BeltIconAmmo3006
	LargeIconWidth=43
	LargeIconHeight=31
	Description="Its high velocity and accuracy have made sniper rifles using the 30.06 round the preferred tool of individuals requiring 'one shot, one kill' for over fifty years."
	BeltDescription="3006 AMMO"
	Mesh=HXAmmo3006Mesh
	CollisionRadius=8.00
	//CollisionHeight=3.86
	CollisionHeight=3.11
	bCollideActors=True
}
