//=============================================================================
// HXAmmoCrate.
//
// Copy of the DXMP AmmoCrate. Restocks Ammo up to the PickupAmmoCount of the
// carried Weapons (e.g. this does not a max out the Ammo).
//=============================================================================
class HXAmmoCrate extends HXContainers;

var localized String AmmoReceived;
var localized String AmmoFull;

// ----------------------------------------------------------------------------
// Frob()
//
// Restock Ammo for Weapons the frobbing player carries around.
// ----------------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local HXPlayerPawn PlayerPawn;
	local Inventory CurrentItem;
	local int Restocked;

	local Actor A;
	local Pawn P;
	

	PlayerPawn = HXPlayerPawn(Frobber);

	if ( PlayerPawn!=None )
	{
		CurrentItem = PlayerPawn.Inventory;
		while ( CurrentItem!=None )
		{
			if ( CurrentItem.IsA('HXWeapon') )
				Restocked += RestockWeapon( PlayerPawn, HXWeapon(CurrentItem) );
			CurrentItem = CurrentItem.Inventory;
		}

		if ( Restocked>0 )
		{
			PlayerPawn.ClientMessage( AmmoReceived );
			PlaySound( Sound'WeaponPickup', SLOT_None, 0.5+FRand()*0.25, , 256, 0.95+FRand()*0.1 );
		}
		else
		{
			PlayerPawn.ClientMessage( AmmoFull );
		}
	}
}

// ----------------------------------------------------------------------------
// RestockWeapon()
//
// Returns Amount of Ammo restocked.
// ----------------------------------------------------------------------------

function int RestockWeapon( HXPlayerPawn PlayerPawn, HXWeapon WeaponToStock )
{
	local int RestockAmount;
	local Ammo AmmoType;

	if ( WeaponToStock.AmmoType!=None )
	{
		if ( WeaponToStock.AmmoNames[0]==None )
			AmmoType = Ammo(PlayerPawn.FindInventoryType(WeaponToStock.AmmoName));
		else
			AmmoType = Ammo(PlayerPawn.FindInventoryType(WeaponToStock.AmmoNames[0]));

		if ( AmmoType!=None && AmmoType.AmmoAmount<WeaponToStock.PickupAmmoCount )
		{
			RestockAmount = WeaponToStock.PickupAmmoCount - AmmoType.AmmoAmount;
			AmmoType.AddAmmo( RestockAmount );
			return RestockAmount;
		}
	}
	return 0;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	AmmoReceived="Ammo restocked."
	AmmoFull="You can't restock more Ammo."
	HitPoints=4000
	bFlammable=False
	ItemName="Ammo Crate"
	bPushable=False
	bBlockSight=True
	Mesh=DXMPAmmobox
	bAlwaysRelevant=True
	CollisionRadius=22.50
	//CollisionHeight=16.00
	CollisionHeight=15.25
	Mass=3000.0
	Buoyancy=40.0
}
