//=============================================================================
// HXAmmoInfoWindow.
//=============================================================================
class HXAmmoInfoWindow extends HXAlignButtonWindow;

var PersonaNormalTextWindow WinText;
var Window WinIcon;
var bool bShowDescriptions;
var bool bSelected;

//var Texture TexBorders[9];
var Texture FillTexture;
//var Color ColSelectionBorder;
var Color ColFillSelected;

var localized String AmmoRoundsLabel;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetChildVAlignment( VALIGN_Top );
	SetChildSpacing( 4 );

	// Add icon
	WinIcon = NewChild( Class'Window' );
	WinIcon.SetBackgroundStyle( DSTY_Masked );
	WinIcon.SetSize( 42, 37 );

	// Add description
	WinText = PersonaNormalTextWindow( NewChild(Class'PersonaNormalTextWindow') );
	WinText.SetWordWrap( True );
	WinText.SetTextMargins( 0, 0 );
	WinText.SetTextAlignments( HALIGN_Left, VALIGN_Top );

	StyleChanged();

	bTickEnabled = True;
}

// ----------------------------------------------------------------------
// SetAmmo()
// ----------------------------------------------------------------------

function SetAmmo( HXAmmo Ammo, bool bNewShowDescriptions )
{
	SetClientObject( Ammo );
	bShowDescriptions = bNewShowDescriptions;

	Update();
}

// ----------------------------------------------------------------------
// Update()
// ----------------------------------------------------------------------

function Update()
{
	local HXAmmo Ammo;

	Ammo = GetAmmo();

	if ( Ammo!=None )
	{
		WinIcon.SetBackground( Ammo.Icon );

		if ( bShowDescriptions )
		{
			WinText.SetText( Ammo.ItemName @ "(" $ AmmoRoundsLabel @ Ammo.AmmoAmount $ ")|n|n" );
			WinText.AppendText( Ammo.description );
		}
		else
		{
			WinText.SetText( Ammo.ItemName $ "|n|n" $ AmmoRoundsLabel @ Ammo.AmmoAmount );
		}
	}
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick( float DeltaSeconds )
{
	Update();
}

// ----------------------------------------------------------------------
// GetAmmo()
// ----------------------------------------------------------------------

function HXAmmo GetAmmo()
{
	return HXAmmo(GetClientObject());
}

// ----------------------------------------------------------------------
// GetAmmoClass()
// ----------------------------------------------------------------------

function Class<HXAmmo> GetAmmoClass()
{
	local HXAmmo Ammo;

	Ammo = GetAmmo();
	if ( Ammo!=None )
		return Ammo.Class;

	return None;
}

// ----------------------------------------------------------------------
// SelectButton()
// ----------------------------------------------------------------------

function SelectButton( bool bNewSelected )
{
	bSelected = bNewSelected;
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow( GC GC )
{	
	Super.DrawWindow( GC );

	if ( bSelected )
	{
		// Draw the background.
		GC.SetStyle( DSTY_Translucent );
		GC.SetTileColor( ColFillSelected );
		//GC.DrawPattern( 1, 1, Width-2, Height-2, 0, 0, FillTexture );
		GC.DrawPattern( 0, 0, Width, Height, 0, 0, FillTexture );

		// Draw selection border.
		//GC.SetTileColor( ColSelectionBorder );
		//GC.SetStyle( DSTY_Masked );
		//GC.DrawBorders( 0, 0, Width, Height, 0, 0, 0, 0, TexBorders );
	}
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme Theme;
	local Color ColBackground;

	Theme = HXPlayerPawn(GetPlayerPawn()).ThemeManager.GetCurrentHUDColorTheme();

	ColBackground = theme.GetColorFromName('HUDColor_Background');
	ColFillSelected.r = Int(Float(ColBackground.r) * 0.50);
	ColFillSelected.g = Int(Float(ColBackground.g) * 0.50);
	ColFillSelected.b = Int(Float(ColBackground.b) * 0.50);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	AmmoRoundsLabel="Rounds:"
	//TexBorders(0)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_TL'
	//TexBorders(1)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_TR'
	//TexBorders(2)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_BL'
	//TexBorders(3)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_BR'
	//TexBorders(4)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_Left'
	//TexBorders(5)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_Right'
	//TexBorders(6)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_Top'
	//TexBorders(7)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_Bottom'
	//TexBorders(8)=Texture'DeusExUI.UserInterface.PersonaItemHighlight_Center'
	//ColSelectionBorder=(R=255,G=255,B=255)
	FillTexture=Texture'Extension.Solid'
}
