//=============================================================================
// HXAmmoNone.
//
// Special ammo type for hand to hand weapons.
//=============================================================================
class HXAmmoNone extends HXDeusExAmmo;

// ----------------------------------------------------------------------------
// CanBeDropped()
//
// Called by HXPlayerPawn.DropItem() to see if we cannot be dropped for some
// reason.
// ----------------------------------------------------------------------------

function bool CanBeDropped( optional bool bSilent )
{
	// Handle this later over DropItem, not DropAmmo.
	if ( !bSilent )
		Pawn(Owner).ClientMessage( "!! Tried to drop AmmoNone !!.", 'StatusLine' );
	return false;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="AmmoNone"
	PickupViewMesh=TestBox
	Mesh=TestBox
	CollisionRadius=22.50
	//CollisionHeight=16.00
	CollisionHeight=15.25
	bCollideActors=True
}
