//=============================================================================
// HXAmmoSabot.
//=============================================================================
class HXAmmoSabot extends HXDeusExAmmo;

// ----------------------------------------------------------------------------
// UseAmmo()
// ----------------------------------------------------------------------------

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing2 shell;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;
      if ((HXGameInfo(Level.Game) != None) && (!HXGameInfo(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
      }
		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bShowInfo=True
	AmmoAmount=12
	MaxAmmo=96
	ItemName="12 Gauge Sabot Shells"
	ItemArticle="some"
	PickupViewMesh=AmmoShell
	Icon=BeltIconAmmoSabot
	LargeIcon=LargeIconAmmoSabot
	LargeIconWidth=35
	LargeIconHeight=46
	Description="A 12 gauge shotgun shell surrounding a solid core of tungsten that can punch through all but the thickest hardened steel armor at close range; however, its ballistic profile will result in minimal damage to soft targets."
	BeltDescription="SABOT"
	Skin=AmmoShellTex2
	Mesh=AmmoShell
	CollisionRadius=9.30
	//CollisionHeight=10.21
	CollisionHeight=9.46
	bCollideActors=True
}
