//=============================================================================
// HXAmmoShell.
//=============================================================================
class HXAmmoShell extends HXDeusExAmmo;

// ----------------------------------------------------------------------------
// SimUseAmmo((
//
// Spawns shell casings client side.
// ----------------------------------------------------------------------------

simulated function bool SimUseAmmo()
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing2 shell;

	if ( AmmoAmount > 0 )
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
		shell.RemoteRole = ROLE_None;

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

// ----------------------------------------------------------------------------
// UseAmmo()
// ----------------------------------------------------------------------------

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing2 shell;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;
      if ( HXGameInfo(Level.Game) != None )
      {
			if ( Level.NetMode == NM_ListenServer )
			{
	         shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
				shell.RemoteRole = ROLE_None;
			}
			else
	         shell = None;
      }
      else
      {
         shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
      }
		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bShowInfo=True
	AmmoAmount=12
	MaxAmmo=96
	ItemName="12 Gauge Buckshot Shells"
	ItemArticle="some"
	PickupViewMesh=AmmoShell
	Icon=BeltIconAmmoShells
	LargeIcon=LargeIconAmmoShells
	LargeIconWidth=34
	LargeIconHeight=45
	Description="Standard 12 gauge shotgun shell; very effective for close-quarters combat against soft targets, but useless against body armor."
	BeltDescription="BUCKSHOT"
	Mesh=AmmoShell
	CollisionRadius=9.30
	//CollisionHeight=10.21
	CollisionHeight=9.46
	bCollideActors=True
}
