//=============================================================================
// HXAnnaNavarre.
//=============================================================================
class HXAnnaNavarre extends HXHumanMilitary;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

// Copying CollisionSize is suspended for now, making this quirk obsolete.
/*
function Succeeds( Actor Other )
{
	local AnnaNavarre OtherAnnaNavarre;

	// Call Super.
	Super.Succeeds( Other );

	// Special AnnaNavarre Init.
	OtherAnnaNavarre = AnnaNavarre(Other);
	if ( OtherAnnaNavarre!=None )
	{
		// Original CollisionHeight didn't match the other GFM_TShirtPants characters.
		if ( OtherAnnaNavarre.CollisionHeight==(OtherAnnaNavarre.default.CollisionHeight-4.5) && OtherAnnaNavarre.CollisionRadius==OtherAnnaNavarre.default.CollisionRadius ) 
		{
			SetCollisionSize( default.CollisionRadius, default.CollisionHeight );
		}
	}
}
*/

// ----------------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass.
// ----------------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if ( bStunned )
		return Super.SpawnCarcass();

	Explode();

	return None;
}

function Explode()
{
	local HXSphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'HXSphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}

	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}

function Bool HasTwoHandedWeapon()
{
	return False;
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') || (damageType == 'Poison') || (damageType == 'PoisonEffect'))
		return 0;
	else
		return Super.ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CarcassType=AnnaNavarreCarcass
	WalkingSpeed=0.28
	bImportant=True
	bInvincible=True
	CloseCombatMult=0.5
	BaseAssHeight=-18.0
	InitialInventory(0)=(Inventory=Class'WeaponAssaultGun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=12)
	InitialInventory(2)=(Inventory=Class'WeaponCombatKnife')
	BurnPeriod=5.0
	bHasCloak=True
	CloakThreshold=100
	WalkAnimMult=1.0
	bIsFemale=True
	GroundSpeed=220.0
	BaseEyeHeight=38.0
	Health=300
	HealthHead=400
	HealthTorso=300
	HealthLegLeft=300
	HealthLegRight=300
	HealthArmLeft=300
	HealthArmRight=300
	Mesh=GFM_TShirtPants
	DrawScale=1.1
	MultiSkins(0)=AnnaNavarreTex0
	MultiSkins(1)=PinkMaskTex
	MultiSkins(2)=PinkMaskTex
	MultiSkins(3)=GrayMaskTex
	MultiSkins(4)=BlackMaskTex
	MultiSkins(5)=AnnaNavarreTex0
	MultiSkins(6)=PantsTex9
	MultiSkins(7)=AnnaNavarreTex1
	CollisionRadius=22.00
	// Original incorrect CollisionHeight.
	////CollisionHeight=47.30
	//CollisionHeight=42.80
	// Adjusted to match other GFM_TShirtPants uses.
	//CollisionHeight=46.85
	CollisionHeight=42.35
	BindName="AnnaNavarre"
	FamiliarName="Anna Navarre"
	UnfamiliarName="Anna Navarre"
	HitSound1=FemalePainMedium
	HitSound2=FemalePainLarge
	Die=FemaleDeath
}
