//=============================================================================
// HXAttackHelicopter.
//=============================================================================
class HXAttackHelicopter extends HXVehicles;

// ----------------------------------------------------------------------------
// state Flying.
// ----------------------------------------------------------------------------

auto state Flying
{
	function BeginState()
	{
		Super.BeginState();
		LoopAnim( 'Fly' );
	}
}

// ----------------------------------------------------------------------------
// SupportActor()
// ----------------------------------------------------------------------------

singular function SupportActor( Actor StandingActor )
{
	// Kill whatever lands on the blades.
	if ( StandingActor!=None )
		StandingActor.TakeDamage( 10000, None, StandingActor.Location, Vect(0,0,0), 'Heliblade' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Attack Helicopter"
	Mesh=AttackHelicopter
	SoundRadius=160
	SoundVolume=192
	AmbientSound=Helicopter
	CollisionRadius=461.23
	//CollisionHeight=87.84
	CollisionHeight=87.09
	Mass=6000.0
	Buoyancy=1000.0
}
