//=============================================================================
// HXAugAqualung.
//=============================================================================
class HXAugAqualung extends HXAugmentation;

var transient HXPlayerPawn PlayerPawn;
var float Mult, Pct;

// ----------------------------------------------------------------------------
// state Active 
//
// Each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on.
// ----------------------------------------------------------------------------

state Active
{

Begin:
	PlayerPawn = HXPlayerPawn(Player);
	if ( PlayerPawn!=None )
	{
		Mult                      = PlayerPawn.SkillSystem.GetSkillLevelValue( Class'HXSkillSwimming' );
		Pct                       = PlayerPawn.DiveTimer / PlayerPawn.DiveDuration;
		PlayerPawn.UnderWaterTime = LevelValues[CurrentLevel];
		PlayerPawn.DiveDuration   = PlayerPawn.UnderWaterTime * Mult;
		PlayerPawn.DiveTimer      = PlayerPawn.DiveDuration   * Pct;
	}
}

// ----------------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------------

function Deactivate()
{
	Super.Deactivate();
	
	PlayerPawn = HXPlayerPawn(Player);
	if ( PlayerPawn!=None )
	{
		Mult                      = PlayerPawn.SkillSystem.GetSkillLevelValue( Class'HXSkillSwimming' );
		Pct                       = PlayerPawn.DiveTimer / PlayerPawn.DiveDuration;
		PlayerPawn.UnderWaterTime = PlayerPawn.Default.UnderWaterTime;
		PlayerPawn.DiveDuration   = PlayerPawn.UnderWaterTime * Mult;
		PlayerPawn.DiveTimer      = PlayerPawn.DiveDuration   * Pct;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnergyRate=10.0
	Icon=AugIconAquaLung
	SmallIcon=AugIconAquaLung_Small
	AugmentationName="Aqualung"
	Description="Soda lime exostructures embedded in the alveoli of the lungs convert CO2 to O2, extending the time an agent can remain underwater.|n|nTECH ONE: Lung capacity is extended slightly.|n|nTECH TWO: Lung capacity is extended moderately.|n|nTECH THREE: Lung capacity is extended significantly.|n|nTECH FOUR: An agent can stay underwater indefinitely."
	LevelValues(0)=30.0
	LevelValues(1)=60.0
	LevelValues(2)=120.0
	LevelValues(3)=240.0
	AugmentationLocation=LOC_Torso
}
