//=============================================================================
// HXAugCloak.
//=============================================================================
class HXAugCloak extends HXAugmentation;

// ----------------------------------------------------------------------------
// GetEnergyRate()
// ----------------------------------------------------------------------------

simulated function float GetEnergyRate()
{
	return EnergyRate*LevelValues[CurrentLevel];
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnergyRate=300.0
	Icon=AugIconCloak
	SmallIcon=AugIconCloak_Small
	AugmentationName="Cloak"
	Description="Subdermal pigmentation cells allow the agent to blend with their surrounding environment, rendering them effectively invisible to observation by organic hostiles.|n|nTECH ONE: Power drain is normal.|n|nTECH TWO: Power drain is reduced slightly.|n|nTECH THREE: Power drain is reduced moderately.|n|nTECH FOUR: Power drain is reduced significantly."
	LevelValues(0)=1.00
	LevelValues(1)=0.83
	LevelValues(2)=0.66
	LevelValues(3)=0.50
	AugmentationLocation=LOC_Subdermal
	// This was added after RTM. Even worse these were played as additional sounds.
	// With them set as ActivateSound/DeActivateSound it sounds at least halfway decent.
	//ActivateSound=CloakUp
	//DeActivateSound=CloakDown
}
