//=============================================================================
// HXAugDefense.
//=============================================================================
class HXAugDefense extends HXAugmentation;

//var float mpAugValue;
//var float mpEnergyDrain;
var bool bDefenseActive;

var float defenseSoundTime;
const defenseSoundDelay = 2;

// ----------------------------------------------------------------------------
// Networking replication.
// ----------------------------------------------------------------------------

replication
{
   //server to client variable propagation.
   reliable if (Role == ROLE_Authority)
      bDefenseActive;

   //server to client function call
   reliable if (Role == ROLE_Authority)
      TriggerDefenseAugHUD, SetDefenseAugStatus;
}

// ----------------------------------------------------------------------------
// state Active 
//
// Each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on.
// ----------------------------------------------------------------------------

state Active
{
	function Timer()
	{
		local HXProjectile minproj;
		local float mindist;

		minproj = None;

      // DEUS_EX AMSD Multiplayer check
      if (Player == None)
      {
         SetTimer(0.1,False);
         return;
      }

      //DEUS_EX AMSD Exported to function call for duplication in multiplayer.
      minproj = FindNearestProjectile();

		// if we have a valid projectile, send it to the aug display window
		if (minproj != None)
		{
         bDefenseActive = True;
         mindist = VSize(Player.Location - minproj.Location);

         // DEUS_EX AMSD In multiplayer, let the client turn his HUD on here.
         // In singleplayer, turn it on normally.
         if (Level.Netmode != NM_Standalone)
            TriggerDefenseAugHUD();
         else
         {         
            SetDefenseAugStatus(True,CurrentLevel,minproj);
         }

			// play a warning sound
			Player.PlaySound(sound'GEPGunLock', SLOT_None,,,, 2.0);

			if (mindist < LevelValues[CurrentLevel])
			{
            minproj.bAggressiveExploded=True;
				minproj.Explode(minproj.Location, vect(0,0,1));
				Player.PlaySound(sound'ProdFire', SLOT_None,,,, 2.0);
			}
		}
		else
		{
         if ((Level.NetMode == NM_Standalone) || (bDefenseActive))
            SetDefenseAugStatus(False,CurrentLevel,None);
         bDefenseActive = false;
		}
	}

Begin:
	SetTimer(0.1, True);
}

function Deactivate()
{
	Super.Deactivate();

	SetTimer(0.1, False);
   SetDefenseAugStatus(False,CurrentLevel,None);
}

// ------------------------------------------------------------------------------
// FindNearestProjectile()
// DEUS_EX AMSD Exported to a function since it also needs to exist in the client
// TriggerDefenseAugHUD;
// ------------------------------------------------------------------------------

simulated function HXProjectile FindNearestProjectile()
{
   local HXProjectile proj, minproj;
   local float dist, mindist;
   local bool bValidProj;

   minproj = None;
   mindist = 999999;
   foreach AllActors(class'HXProjectile', proj)
   {
      //if (Level.NetMode != NM_Standalone)
         bValidProj = !proj.bIgnoresNanoDefense;
      //else
         //bValidProj = (!proj.IsA('HXCloud') && !proj.IsA('HXTracer') && !proj.IsA('HXGreaselSpit') && !proj.IsA('HXGraySpit'));

      if (bValidProj)
      {
         // make sure we don't own it
         //if (proj.Owner != Player)
         if ( !( proj.Owner.isA('HXPlayerPawn') ) )
         {
				// make sure it's moving fast enough
				if (VSize(proj.Velocity) > 100)
				{
				   dist = VSize(Player.Location - proj.Location);
				   if (dist < mindist)
				   {
					  mindist = dist;
					  minproj = proj;
				   }
				}
         }
      }
   }

   return minproj;
}

// ------------------------------------------------------------------------------
// TriggerDefenseAugHUD()
// ------------------------------------------------------------------------------

simulated function TriggerDefenseAugHUD()
{
   local HXProjectile minproj;
   
   minproj = None;
      
   minproj = FindNearestProjectile();
   
   // if we have a valid projectile, send it to the aug display window
   // That's all we do.
   if (minproj != None)
   {
      SetDefenseAugStatus(True,CurrentLevel,minproj);      
   }
}

// ------------------------------------------------------------------------------
// Tick()
// ------------------------------------------------------------------------------

simulated function Tick(float DeltaTime)
{
   Super.Tick(DeltaTime);

   // DEUS_EX AMSD Make sure it gets turned off in multiplayer.
   if (Level.NetMode == NM_Client)
   {
      if (!bDefenseActive)
         SetDefenseAugStatus(False,CurrentLevel,None);
   }
}

// ------------------------------------------------------------------------------
// SetDefenseAugStatus()
// ------------------------------------------------------------------------------

simulated function SetDefenseAugStatus(bool bDefenseActive, int defenseLevel, HXProjectile defenseTarget)
{
   if (Player == None)
      return;
   if (Player.rootWindow == None)
      return;
   HXAugmentationDisplayWindow(HXRootWindow(Player.rootWindow).hud.augDisplay).bDefenseActive = bDefenseActive;
   HXAugmentationDisplayWindow(HXRootWindow(Player.rootWindow).hud.augDisplay).defenseLevel = defenseLevel;
   HXAugmentationDisplayWindow(HXRootWindow(Player.rootWindow).hud.augDisplay).HXDefenseTarget = defenseTarget;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EnergyRate=10.0
	Icon=AugIconDefense
	SmallIcon=AugIconDefense_Small
	AugmentationName="Aggressive Defense System"
	Description="Aerosol nanoparticles are released upon the detection of objects fitting the electromagnetic threat profile of missiles and grenades; these nanoparticles will prematurely detonate such objects prior to reaching the agent.|n|nTECH ONE: The range at which incoming rockets and grenades are detonated is short.|n|nTECH TWO: The range at which detonation occurs is increased slightly.|n|nTECH THREE: The range at which detonation occurs is increased moderately.|n|nTECH FOUR: Rockets and grenades are detonated almost before they are fired."
	LevelValues(0)=160.0
	LevelValues(1)=320.0
	LevelValues(2)=480.0
	LevelValues(3)=800.0
}
