//=============================================================================
// HXAugDrone.
//
// Maybe use a ticking downwards timer for drone reconstruction timeout.
// This could even travel, etc.
//=============================================================================
class HXAugDrone extends HXAugmentation;

var        float ReconstructionDelay; // Time need after aug deactivation until next activation.
var travel float ReconstructionTime;  // Timer used to track reconstruction.

var localized string MsgReconstructionIncompleteSingular;
var localized string MsgReconstructionIncompletePlural;
var localized string MsgReconstructionCompleted;

// ----------------------------------------------------------------------------
// state Active 
//
// Each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on.
// ----------------------------------------------------------------------------

state Active
{

Begin:
	Player.bSpyDroneActive    = True;
	Player.SpyDroneLevel      = CurrentLevel;
	Player.SpyDroneLevelValue = LevelValues[CurrentLevel];
}

// ----------------------------------------------------------------------------
// SpecialActivation()
//
// Called by Activate to check whether this aug has special requirements
// other than beeing present (Health below 100, new drone ready, etc.).
//
// Can return false to cancel activation.
// ----------------------------------------------------------------------------

function bool SpecialActivation()
{
	local string Message;

	if ( ReconstructionTime==0.0 )
		return true;

	// This will never show 0 seconds remaining.
	if ( int(ReconstructionTime)>1 )
		Message = Sprintf( MsgReconstructionIncompletePlural, int(ReconstructionTime) );
	else
		Message = MsgReconstructionIncompleteSingular;

	// Give some feedback.
	Player.PlaySound( DeactivateSound, SLOT_None );
	Player.ClientMessage( Message, 'StatusLine' );
	return false;
}

// ----------------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------------

function Deactivate()
{
	Super.Deactivate();

	// Reset ReconstructionTimer.
	if ( Player.bSpyDroneActive )
		ReconstructionTime = ReconstructionDelay;

	Player.bSpyDroneActive = false;
}

// ----------------------------------------------------------------------------
// ReconstructionTimer()
// ----------------------------------------------------------------------------

function ReconstructionTimer()
{
	Player.ClientMessage( MsgReconstructionCompleted, 'StatusLine' );
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );

	if ( Role==ROLE_Authority )
	{
		// Additional ReconstructionTimer().
		if ( ReconstructionTime>0.0 )
		{
			ReconstructionTime -= DeltaTime;

			if ( ReconstructionTime<0.001 )
			{
				ReconstructionTime = 0.0;
				ReconstructionTimer();
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ReconstructionDelay=30.0
	EnergyRate=150.0
	Icon=AugIconDrone
	SmallIcon=AugIconDrone_Small
	AugmentationName="Spy Drone"
	Description="Advanced nanofactories can assemble a spy drone upon demand which can then be remotely controlled by the agent until released or destroyed, at which a point a new drone will be assembled. Further upgrades equip the spy drones with better armor and a one-shot EMP attack.|n|nTECH ONE: The drone can take little damage and has a very light EMP attack.|n|nTECH TWO: The drone can take minor damage and has a light EMP attack.|n|nTECH THREE: The drone can take moderate damage and has a medium EMP attack.|n|nTECH FOUR: The drone can take heavy damage and has a strong EMP attack."
	LevelValues(0)=10.0
	LevelValues(1)=20.0
	LevelValues(2)=35.0
	LevelValues(3)=50.0
	// Are these too long for PersonaScreen?
	MsgReconstructionIncompleteSingular="Drone reconstruction will be complete in 1 second"
	MsgReconstructionIncompletePlural="Drone reconstruction will be complete in %s seconds"
	MsgReconstructionCompleted="Drone reconstruction completed"
}
