//=============================================================================
// HXAugHealing.
//=============================================================================
class HXAugHealing extends HXAugmentation;

var localized string MsgAlreadyFullHealth;

// ----------------------------------------------------------------------------
// state Active 
//
// Each augmentation should have its own version of this which actually
// implements the effects of having the augmentation on.
// ----------------------------------------------------------------------------

state Active
{

Begin:
	// Maybe use sth. like CanBeHealed()? HealPlayer returning a bool, or sth.
	if ( Player.Health<Player.default.Health )
		Player.HealPlayer( int(LevelValues[CurrentLevel]), false );
	else
		Deactivate();

	Player.ClientFlash(0.5, vect(0, 0, 500));
	Sleep(1.0);
	Goto('Begin');
}

// ----------------------------------------------------------------------------
// SpecialActivation()
//
// Called by Activate to check whether this aug has special requirements
// other than beeing present (Health below 100, new drone ready, etc.).
//
// Can return false to cancel activation.
// ----------------------------------------------------------------------------

function bool SpecialActivation()
{
	if ( Player.Health<Player.default.Health )
		return true;

	// Give some feedback.
	Player.PlaySound( DeactivateSound, SLOT_None );
	Player.ClientMessage( MsgAlreadyFullHealth, 'StatusLine' );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MsgAlreadyFullHealth="You are already in full health."
	EnergyRate=120.0
	Icon=AugIconHealing
	SmallIcon=AugIconHealing_Small
	AugmentationName="Regeneration"
	Description="Programmable polymerase automatically directs construction of proteins in injured cells, restoring an agent to full health over time.|n|nTECH ONE: Healing occurs at a normal rate.|n|nTECH TWO: Healing occurs at a slightly faster rate.|n|nTECH THREE: Healing occurs at a moderately faster rate.|n|nTECH FOUR: Healing occurs at a significantly faster rate."
	LevelValues(0)=5.0
	LevelValues(1)=15.0
	LevelValues(2)=25.0
	LevelValues(3)=40.0
	AugmentationLocation=LOC_Torso
}
